/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.council.entity.CouncilParty;
import org.egov.council.repository.CouncilPartyRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CouncilPartyService {
    private final CouncilPartyRepository councilPartyRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public CouncilPartyService(CouncilPartyRepository councilPartyRepository) {
        this.councilPartyRepository = councilPartyRepository;
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public CouncilParty create(CouncilParty councilParty) {
        return (CouncilParty)((Object)this.councilPartyRepository.save((Object)councilParty));
    }

    @Transactional
    public CouncilParty update(CouncilParty councilParty) {
        return (CouncilParty)((Object)this.councilPartyRepository.save((Object)councilParty));
    }

    public List<CouncilParty> findAll() {
        return this.councilPartyRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public CouncilParty findByName(String name) {
        return this.councilPartyRepository.findByName(name);
    }

    public CouncilParty findOne(Long id) {
        return (CouncilParty)((Object)this.councilPartyRepository.findOne(id));
    }

    public List<CouncilParty> getActiveParties() {
        return this.councilPartyRepository.findByisActive(true);
    }

    public List<CouncilParty> search(CouncilParty councilParty) {
        Criteria criteria = this.getCurrentSession().createCriteria(CouncilParty.class);
        if (null != councilParty.getName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)councilParty.getName(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (councilParty.getIsActive() != null && councilParty.getIsActive().booleanValue()) {
            criteria.add((Criterion)Restrictions.eq((String)"isActive", (Object)councilParty.getIsActive()));
        }
        return criteria.list();
    }
}

