/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.ArrayUtils;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.council.entity.CouncilAgendaDetails;
import org.egov.council.entity.CouncilMeeting;
import org.egov.council.entity.MeetingAttendence;
import org.egov.council.entity.MeetingMOM;
import org.egov.council.repository.CouncilMeetingRepository;
import org.egov.council.repository.CouncilMoMRepository;
import org.egov.council.repository.MeetingAttendanceRepository;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.DateUtils;
import org.egov.pims.commons.Position;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class CouncilMeetingService {
    private static final String STATUS_DOT_CODE = "status.code";
    private final CouncilMeetingRepository councilMeetingRepository;
    private final MeetingAttendanceRepository meetingAttendanceRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private CouncilMoMRepository councilMoMRepository;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private UserService userService;
    @Autowired
    private FileStoreService fileStoreService;

    @Autowired
    public CouncilMeetingService(CouncilMeetingRepository councilMeetingRepository, MeetingAttendanceRepository meetingAttendance) {
        this.councilMeetingRepository = councilMeetingRepository;
        this.meetingAttendanceRepository = meetingAttendance;
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public CouncilMeeting create(CouncilMeeting councilMeeting) {
        return (CouncilMeeting)((Object)this.councilMeetingRepository.save((Object)councilMeeting));
    }

    @Transactional
    public CouncilMeeting update(CouncilMeeting councilMeeting) {
        return (CouncilMeeting)((Object)this.councilMeetingRepository.save((Object)councilMeeting));
    }

    @Transactional
    public List<MeetingMOM> createDataEntry(List<MeetingMOM> meetingMOM) {
        return this.councilMoMRepository.save(meetingMOM);
    }

    public List<CouncilMeeting> findAll() {
        return this.councilMeetingRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"meetingDate"}));
    }

    public CouncilMeeting findOne(Long id) {
        return this.councilMeetingRepository.findById(id);
    }

    public List<MeetingAttendence> findListOfAttendance(CouncilMeeting id) {
        return this.meetingAttendanceRepository.findByMeeting(id);
    }

    public CouncilMeeting findByMeetingNumber(String meetingNumber) {
        return this.councilMeetingRepository.findByMeetingNumber(meetingNumber);
    }

    public MeetingMOM findByResolutionNumber(String resolutionNumber) {
        return this.councilMoMRepository.findByResolutionNumber(resolutionNumber);
    }

    public CouncilMeeting updateMoMStatus(CouncilMeeting councilMeeting) {
        for (MeetingMOM meetingMOM : councilMeeting.getMeetingMOMs()) {
            if (!meetingMOM.getResolutionStatus().getCode().equals("ADJOURNED")) continue;
            meetingMOM.getPreamble().setStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", "ADJOURNED"));
        }
        return councilMeeting;
    }

    public List<CouncilMeeting> searchMeetingToCreateMOM(CouncilMeeting councilMeeting) {
        return this.buildSearchCriteria(councilMeeting).add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new Object[]{"APPROVED", "ATTENDANCE FINALIZED"})).list();
    }

    public List<CouncilMeeting> searchMeeting(CouncilMeeting councilMeeting) {
        return this.buildSearchCriteria(councilMeeting).list();
    }

    public List<CouncilMeeting> searchMeetingForEdit(CouncilMeeting councilMeeting) {
        return this.buildSearchCriteria(councilMeeting).add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new Object[]{"APPROVED", "ATTENDANCE FINALIZED"})).list();
    }

    public List<CouncilMeeting> searchMeetingWithMomCreatedStatus(CouncilMeeting councilMeeting) {
        return this.buildSearchCriteria(councilMeeting).add(Restrictions.in((String)STATUS_DOT_CODE, (Object[])new Object[]{"MOM CREATED"})).list();
    }

    public void sortMeetingMomByItemNumber(CouncilMeeting councilMeeting) {
        councilMeeting.getMeetingMOMs().sort((f1, f2) -> Long.valueOf(f1.getItemNumber()).compareTo(Long.valueOf(f2.getItemNumber())));
    }

    public Criteria buildSearchCriteria(CouncilMeeting councilMeeting) {
        Criteria criteria = this.getCurrentSession().createCriteria(CouncilMeeting.class, "councilMeeting").createAlias("councilMeeting.status", "status");
        if (councilMeeting.getCommitteeType() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"committeeType", (Object)((Object)councilMeeting.getCommitteeType())));
        }
        if (councilMeeting.getMeetingNumber() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"meetingNumber", (Object)councilMeeting.getMeetingNumber()));
        }
        if (councilMeeting.getFromDate() != null && councilMeeting.getToDate() != null) {
            criteria.add(Restrictions.between((String)"meetingDate", (Object)councilMeeting.getFromDate(), (Object)DateUtils.addDays((Date)councilMeeting.getToDate(), (int)1)));
        }
        if (councilMeeting.getMeetingType() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"meetingType", (Object)((Object)councilMeeting.getMeetingType())));
        }
        return criteria;
    }

    @Transactional
    public void deleteAttendance(List<MeetingAttendence> meetingAttendences) {
        this.meetingAttendanceRepository.deleteInBatch(meetingAttendences);
    }

    public List<User> getUserListForMeeting(CouncilMeeting councilMeeting) {
        HashSet<User> usersListResult = new HashSet<User>();
        ArrayList<String> agendaNumber = new ArrayList<String>();
        for (MeetingMOM mom : councilMeeting.getMeetingMOMs()) {
            if (mom == null || mom.getAgenda() == null || agendaNumber.contains(mom.getAgenda().getAgendaNumber()) || mom.getAgenda().getAgendaDetails() == null) continue;
            for (CouncilAgendaDetails agendaDetails : mom.getAgenda().getAgendaDetails()) {
                if (agendaDetails == null || agendaDetails.getPreamble() == null || agendaDetails.getPreamble().getState() == null || agendaDetails.getPreamble().getState().getOwnerPosition() == null) continue;
                usersListResult.add(agendaDetails.getPreamble().getState().getCreatedBy());
                usersListResult.add(this.eisCommonService.getUserForPosition(((Position)agendaDetails.getPreamble().getState().getOwnerPosition()).getId(), new Date()));
            }
            agendaNumber.add(mom.getAgenda().getAgendaNumber());
        }
        usersListResult.add(this.userService.getUserById(councilMeeting.getCreatedBy().getId()));
        return new ArrayList<User>(usersListResult);
    }

    public Set<FileStoreMapper> addToFileStore(MultipartFile[] files) {
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return Arrays.asList(files).stream().filter(file -> !file.isEmpty()).map(file -> {
                try {
                    return this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "COUNCIL");
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("Error occurred while getting inputstream", (Throwable)e);
                }
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

