/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.council.entity.CommitteeMembers;
import org.egov.council.entity.CommitteeType;
import org.egov.council.entity.CouncilMemberStatus;
import org.egov.council.repository.CouncilCommitteeMemberRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CouncilCommitteeMemberService {
    private final CouncilCommitteeMemberRepository councilCommitteeMemberRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public CouncilCommitteeMemberService(CouncilCommitteeMemberRepository councilCommitteeMemberRepository) {
        this.councilCommitteeMemberRepository = councilCommitteeMemberRepository;
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public CommitteeMembers create(CommitteeMembers committeeMember) {
        return (CommitteeMembers)((Object)this.councilCommitteeMemberRepository.save((Object)committeeMember));
    }

    @Transactional
    public CommitteeMembers update(CommitteeMembers committeeMember) {
        return (CommitteeMembers)((Object)this.councilCommitteeMemberRepository.save((Object)committeeMember));
    }

    public List<CommitteeMembers> findAll() {
        return this.councilCommitteeMemberRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public List<CommitteeMembers> findAllByCommitteTypeMemberIsActive(CommitteeType committeeType) {
        Criteria criteria = this.getCurrentSession().createCriteria(CommitteeMembers.class, "committeeMembers").createAlias("committeeMembers.councilMember", "member");
        criteria.add((Criterion)Restrictions.eq((String)"committeeType", (Object)((Object)committeeType)));
        criteria.add((Criterion)Restrictions.eq((String)"member.status", (Object)((Object)CouncilMemberStatus.ACTIVE)));
        return criteria.list();
    }

    public List<CommitteeMembers> findAllByCommitteType(CommitteeType committeeType) {
        return this.councilCommitteeMemberRepository.findByCommitteeType(committeeType);
    }

    public CommitteeMembers findOne(Long id) {
        return (CommitteeMembers)((Object)this.councilCommitteeMemberRepository.findOne(id));
    }

    @Transactional
    public void delete(List<CommitteeMembers> committeeMembers) {
        this.councilCommitteeMemberRepository.deleteInBatch(committeeMembers);
    }
}

