/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.egov.commons.EgwStatus;
import org.egov.council.entity.CommitteeType;
import org.egov.council.entity.CouncilMeetingType;
import org.egov.council.entity.CouncilSmsDetails;
import org.egov.council.entity.MeetingAttendence;
import org.egov.council.entity.MeetingMOM;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Unique(fields={"meetingNumber"}, enableDfltMsg=true)
@Table(name="egcncl_meeting")
@SequenceGenerator(name="seq_egcncl_meeting", sequenceName="seq_egcncl_meeting", allocationSize=1)
public class CouncilMeeting
extends StateAware<Position> {
    public static final String SEQ_MEETING = "seq_egcncl_meeting";
    private static final long serialVersionUID = 5607959287745538396L;
    @Id
    @GeneratedValue(generator="seq_egcncl_meeting", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @JoinColumn(name="committeeType")
    private CommitteeType committeeType;
    @ManyToOne
    @JoinColumn(name="meetingType")
    private CouncilMeetingType meetingType;
    @Column(name="meetingNumber")
    private String meetingNumber;
    @Temporal(value=TemporalType.DATE)
    @Column(name="meetingDate")
    private Date meetingDate;
    @Column(name="meetingTime")
    private String meetingTime;
    @Column(name="meetingLocation")
    private String meetingLocation;
    @ManyToOne
    @JoinColumn(name="status")
    private EgwStatus status;
    @Transient
    private Date fromDate;
    @Transient
    private Date toDate;
    @OrderBy(value="id")
    @OneToMany(mappedBy="meeting", cascade={CascadeType.ALL})
    private List<MeetingMOM> meetingMOMs = new ArrayList<MeetingMOM>();
    @OneToMany(mappedBy="meeting", cascade={CascadeType.ALL})
    private List<MeetingAttendence> meetingAttendence = new ArrayList<MeetingAttendence>();
    @OneToMany(mappedBy="meeting", cascade={CascadeType.ALL})
    private List<CouncilSmsDetails> smsDetails = new ArrayList<CouncilSmsDetails>();
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="filestore")
    private FileStoreMapper filestore;
    @Transient
    private List<MeetingAttendence> updateMeetingAttendance = new ArrayList<MeetingAttendence>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="egcncl_meeting_document", joinColumns={@JoinColumn(name="meetingid")}, inverseJoinColumns={@JoinColumn(name="filestoreid")})
    private Set<FileStoreMapper> supportDocs = Collections.emptySet();
    private transient MultipartFile[] files;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public CommitteeType getCommitteeType() {
        return this.committeeType;
    }

    public void setCommitteeType(CommitteeType committeeType) {
        this.committeeType = committeeType;
    }

    public String getMeetingNumber() {
        return this.meetingNumber;
    }

    public void setMeetingNumber(String meetingNumber) {
        this.meetingNumber = meetingNumber;
    }

    public Date getMeetingDate() {
        return this.meetingDate;
    }

    public void setMeetingDate(Date meetingDate) {
        this.meetingDate = meetingDate;
    }

    public String getMeetingLocation() {
        return this.meetingLocation;
    }

    public void setMeetingLocation(String meetingLocation) {
        this.meetingLocation = meetingLocation;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public String getMeetingTime() {
        return this.meetingTime;
    }

    public void setMeetingTime(String meetingTime) {
        this.meetingTime = meetingTime;
    }

    public String getStateDetails() {
        return String.format("Meeting Number %s ", this.meetingNumber);
    }

    public List<MeetingMOM> getMeetingMOMs() {
        return this.meetingMOMs;
    }

    public void setMeetingMOMs(List<MeetingMOM> meetingMOMs) {
        this.meetingMOMs = meetingMOMs;
    }

    public void addMeetingMoms(MeetingMOM meetingMom) {
        this.meetingMOMs.add(meetingMom);
    }

    public List<MeetingAttendence> getMeetingAttendence() {
        return this.meetingAttendence;
    }

    public void setMeetingAttendence(List<MeetingAttendence> meetingAttendence) {
        this.meetingAttendence = meetingAttendence;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public FileStoreMapper getFilestore() {
        return this.filestore;
    }

    public void setFilestore(FileStoreMapper filestore) {
        this.filestore = filestore;
    }

    public List<CouncilSmsDetails> getSmsDetails() {
        return this.smsDetails;
    }

    public void setSmsDetails(List<CouncilSmsDetails> smsDetails) {
        this.smsDetails = smsDetails;
    }

    public void addSmsDetails(CouncilSmsDetails councilSmsDetails) {
        this.smsDetails.add(councilSmsDetails);
    }

    public List<MeetingAttendence> getUpdateMeetingAttendance() {
        return this.updateMeetingAttendance;
    }

    public void setUpdateMeetingAttendance(List<MeetingAttendence> updateMeetingAttendance) {
        this.updateMeetingAttendance = updateMeetingAttendance;
    }

    public Set<FileStoreMapper> getSupportDocs() {
        return this.supportDocs;
    }

    public void setSupportDocs(Set<FileStoreMapper> supportDocs) {
        this.supportDocs = supportDocs;
    }

    public MultipartFile[] getFiles() {
        return this.files;
    }

    public void setFiles(MultipartFile[] files) {
        this.files = files;
    }

    public CouncilMeetingType getMeetingType() {
        return this.meetingType;
    }

    public void setMeetingType(CouncilMeetingType meetingType) {
        this.meetingType = meetingType;
    }
}

