/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.autonumber.impl;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.egov.council.autonumber.SumotoNumberGenerator;
import org.egov.council.entity.CouncilPreamble;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SumotoNumberGeneratorImpl
implements SumotoNumberGenerator {
    private static final String SUMOTO_NUMBER_SEQ = "SEQ_EGCNCL_SUMOTO_NUMBER";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;

    @Override
    public String getNextNumber(CouncilPreamble councilpreamble) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM");
        String formattedDate = sdf.format(new Date());
        String sequenceName = SUMOTO_NUMBER_SEQ;
        String currentYear = DateUtils.currentDateToYearFormat();
        Serializable sequenceNumber = this.applicationSequenceNumberGenerator.getNextSequence(SUMOTO_NUMBER_SEQ);
        String result = String.format("SR-%d-%s-%s", sequenceNumber, formattedDate, currentYear);
        return result;
    }
}

