/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.council.entity.CouncilDesignation;
import org.egov.council.repository.CouncilDesignationRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CouncilDesignationService {
    private final CouncilDesignationRepository councilDesignationRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public CouncilDesignationService(CouncilDesignationRepository councilDesignationRepository) {
        this.councilDesignationRepository = councilDesignationRepository;
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public CouncilDesignation create(CouncilDesignation councilDesignation) {
        return (CouncilDesignation)((Object)this.councilDesignationRepository.save((Object)councilDesignation));
    }

    @Transactional
    public CouncilDesignation update(CouncilDesignation councilDesignation) {
        return (CouncilDesignation)((Object)this.councilDesignationRepository.save((Object)councilDesignation));
    }

    public List<CouncilDesignation> findAll() {
        return this.councilDesignationRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public CouncilDesignation findByName(String name) {
        return this.councilDesignationRepository.findByName(name);
    }

    public CouncilDesignation findOne(Long id) {
        return (CouncilDesignation)((Object)this.councilDesignationRepository.findOne(id));
    }

    public List<CouncilDesignation> getActiveDesignations() {
        return this.councilDesignationRepository.findByisActive(true);
    }

    public List<CouncilDesignation> search(CouncilDesignation councilDesignation) {
        Criteria criteria = this.getCurrentSession().createCriteria(CouncilDesignation.class);
        if (null != councilDesignation.getName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)councilDesignation.getName(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (councilDesignation.getIsActive() != null && councilDesignation.getIsActive().booleanValue()) {
            criteria.add((Criterion)Restrictions.eq((String)"isActive", (Object)councilDesignation.getIsActive()));
        }
        return criteria.list();
    }
}

