/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.council.entity.CommitteeType;
import org.egov.council.repository.CommitteeTypeRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CommitteeTypeService {
    private final CommitteeTypeRepository committeeTypeRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public CommitteeTypeService(CommitteeTypeRepository committeeTypeRepository) {
        this.committeeTypeRepository = committeeTypeRepository;
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public CommitteeType create(CommitteeType committeeType) {
        return (CommitteeType)((Object)this.committeeTypeRepository.save((Object)committeeType));
    }

    @Transactional
    public void delete(CommitteeType committeeType) {
        this.committeeTypeRepository.delete((Object)committeeType);
    }

    @Transactional
    public CommitteeType update(CommitteeType committeeType) {
        return (CommitteeType)((Object)this.committeeTypeRepository.save((Object)committeeType));
    }

    public List<CommitteeType> findAll() {
        return this.committeeTypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public CommitteeType findByName(String name) {
        return this.committeeTypeRepository.findByName(name);
    }

    public CommitteeType findOne(Long id) {
        return (CommitteeType)((Object)this.committeeTypeRepository.findOne(id));
    }

    public List<CommitteeType> getActiveCommiteeType() {
        return this.committeeTypeRepository.findByisActive(true);
    }

    public List<CommitteeType> search(CommitteeType committeeType) {
        Criteria criteria = this.getCurrentSession().createCriteria(CommitteeType.class);
        if (null != committeeType.getName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)committeeType.getName(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (committeeType.getIsActive() != null && committeeType.getIsActive().booleanValue()) {
            criteria.add((Criterion)Restrictions.eq((String)"isActive", (Object)committeeType.getIsActive()));
        }
        return criteria.list();
    }
}

