/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.egov.commons.EgwStatus;
import org.egov.council.entity.CommitteeType;
import org.egov.council.entity.CouncilAgendaDetails;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.workflow.entity.StateAware;

@Entity
@Unique(id="id", tableName="egcncl_agenda", fields={"agendaNumber"}, columnName={"agendaNumber"}, enableDfltMsg=true)
@Table(name="egcncl_agenda")
@SequenceGenerator(name="seq_egcncl_agenda", sequenceName="seq_egcncl_agenda", allocationSize=1)
public class CouncilAgenda
extends StateAware {
    private static final long serialVersionUID = 6941145759682765506L;
    public static final String SEQ_AGENDA = "seq_egcncl_agenda";
    @Id
    @GeneratedValue(generator="seq_egcncl_agenda", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @JoinColumn(name="committeeType")
    private CommitteeType committeeType;
    @Column(name="agendaNumber")
    private String agendaNumber;
    @ManyToOne
    @JoinColumn(name="status")
    private EgwStatus status;
    @Transient
    private Date fromDate;
    @Transient
    private Date toDate;
    @OneToMany(mappedBy="agenda", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<CouncilAgendaDetails> agendaDetails = new ArrayList<CouncilAgendaDetails>(0);
    @Transient
    private List<CouncilAgendaDetails> councilAgendaDetailsForUpdate = new ArrayList<CouncilAgendaDetails>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public CommitteeType getCommitteeType() {
        return this.committeeType;
    }

    public void setCommitteeType(CommitteeType committeeType) {
        this.committeeType = committeeType;
    }

    public String getAgendaNumber() {
        return this.agendaNumber;
    }

    public void setAgendaNumber(String agendaNumber) {
        this.agendaNumber = agendaNumber;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public List<CouncilAgendaDetails> getAgendaDetails() {
        return this.agendaDetails;
    }

    public void setAgendaDetails(List<CouncilAgendaDetails> agendaDetails) {
        this.agendaDetails = agendaDetails;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public String getStateDetails() {
        return String.format("Agenda Number %s ", this.agendaNumber);
    }

    public List<CouncilAgendaDetails> getCouncilAgendaDetailsForUpdate() {
        return this.councilAgendaDetailsForUpdate;
    }

    public void setCouncilAgendaDetailsForUpdate(List<CouncilAgendaDetails> councilAgendaDetailsForUpdate) {
        this.councilAgendaDetailsForUpdate = councilAgendaDetailsForUpdate;
    }
}

