/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service.es;

import org.egov.council.entity.CouncilMember;
import org.egov.council.entity.es.CouncilMemberIndex;
import org.egov.council.repository.es.CouncilMemberIndexRepository;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CouncilMemberIndexService {
    @Autowired
    private CityService cityService;
    @Autowired
    private CouncilMemberIndexRepository councilMemberIndexRepository;

    public CouncilMemberIndex createCouncilMemberIndex(CouncilMember councilMember) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        CouncilMemberIndex memberIndex = new CouncilMemberIndex();
        memberIndex.setDistrictName(cityWebsite.getDistrictName());
        memberIndex.setUlbGrade(cityWebsite.getGrade());
        memberIndex.setUlbCode(cityWebsite.getCode());
        memberIndex.setRegionName(cityWebsite.getRegionName());
        memberIndex.setUlbName(cityWebsite.getName());
        if (councilMember != null) {
            memberIndex.setId(cityWebsite.getCode().concat("-").concat(councilMember.getId().toString()));
            memberIndex.setName(councilMember.getName() != null ? councilMember.getName() : "");
            memberIndex.setAddress(councilMember.getResidentialAddress() != null ? councilMember.getResidentialAddress() : "");
            memberIndex.setBirthDate(councilMember.getBirthDate() != null ? councilMember.getBirthDate() : null);
            memberIndex.setGender(councilMember.getGender() != null ? councilMember.getGender().toString() : "");
            memberIndex.setEmailId(councilMember.getEmailId() != null ? councilMember.getEmailId() : "");
            memberIndex.setMobileNumber(councilMember.getMobileNumber() != null ? councilMember.getMobileNumber() : "");
            memberIndex.setCaste(councilMember.getCaste() != null ? councilMember.getCaste().getName() : "");
            memberIndex.setDesignation(councilMember.getDesignation() != null ? councilMember.getDesignation().getName() : "");
            memberIndex.setQualification(councilMember.getQualification() != null ? councilMember.getQualification().getDescription() : "");
            memberIndex.setPartyAffiliation(councilMember.getPartyAffiliation() != null ? councilMember.getPartyAffiliation().getName() : "");
            memberIndex.setStatus(councilMember.getStatus() != null ? councilMember.getStatus().name() : "");
            memberIndex.setElectionDate(councilMember.getElectionDate() != null ? councilMember.getElectionDate() : null);
            memberIndex.setOathDate(councilMember.getOathDate() != null ? councilMember.getOathDate() : null);
            memberIndex.setElectionWard(councilMember.getElectionWard() != null ? councilMember.getElectionWard().getName() : "");
            memberIndex.setCreatedDate(councilMember.getCreatedDate());
            memberIndex.setCategory(councilMember.getCategory() != null ? councilMember.getCategory() : "");
            memberIndex.setDateOfJoining(councilMember.getDateOfJoining() != null ? councilMember.getDateOfJoining() : null);
            this.councilMemberIndexRepository.save(memberIndex);
        }
        return memberIndex;
    }
}

