/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.WordUtils;
import org.egov.council.entity.CouncilAgendaDetails;
import org.egov.council.entity.CouncilMeeting;
import org.egov.council.entity.MeetingMOM;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CouncilReportService {
    private static final String AGENDA = "agenda";
    private static final String MEETINGMOM = "meetingMom";
    @Autowired
    private ReportService reportService;

    public byte[] generatePDFForAgendaDetails(CouncilMeeting councilMeeting, String logoPath) {
        ReportRequest reportInput = null;
        if (councilMeeting != null) {
            HashMap<String, List<CouncilAgendaDetails>> agendaDetails = new HashMap<String, List<CouncilAgendaDetails>>();
            List<CouncilAgendaDetails> agendaDetailsList = councilMeeting.getMeetingMOMs().get(0).getAgenda().getAgendaDetails();
            agendaDetailsList.sort((f1, f2) -> f1.getItemNumber().compareTo(f2.getItemNumber()));
            agendaDetails.put("agendaList", agendaDetailsList);
            reportInput = new ReportRequest(AGENDA, agendaDetails, this.buildReportParameters(councilMeeting, logoPath));
        }
        reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
        reportInput.setPrintDialogOnOpenReport(false);
        return this.createReport(reportInput).getReportOutputData();
    }

    public byte[] generatePDFForMom(CouncilMeeting councilMeeting, String logoPath) {
        ReportRequest reportInput = null;
        if (councilMeeting != null) {
            HashMap<String, List<MeetingMOM>> momDetails = new HashMap<String, List<MeetingMOM>>();
            List<MeetingMOM> meetingMomList = councilMeeting.getMeetingMOMs();
            meetingMomList.sort((f1, f2) -> f1.getItemNumber().compareTo(f2.getItemNumber()));
            momDetails.put("meetingMOMList", meetingMomList);
            reportInput = new ReportRequest(MEETINGMOM, momDetails, this.buildReportParameters(councilMeeting, logoPath));
        }
        reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
        reportInput.setPrintDialogOnOpenReport(false);
        return this.createReport(reportInput).getReportOutputData();
    }

    private Map<String, Object> buildReportParameters(CouncilMeeting councilMeeting, String logoPath) {
        StringBuilder meetingDateTimeLocation = new StringBuilder();
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        reportParams.put("logoPath", logoPath);
        reportParams.put("commiteeType", WordUtils.capitalize((String)councilMeeting.getCommitteeType().getName()));
        reportParams.put("meetingNumber", WordUtils.capitalize((String)councilMeeting.getMeetingNumber()));
        meetingDateTimeLocation.append(DateUtils.getDefaultFormattedDate((Date)councilMeeting.getMeetingDate()));
        if (null != councilMeeting.getMeetingTime()) {
            meetingDateTimeLocation.append(' ');
            meetingDateTimeLocation.append(councilMeeting.getMeetingTime());
        }
        if (null != councilMeeting.getMeetingLocation()) {
            meetingDateTimeLocation.append(' ');
            meetingDateTimeLocation.append(councilMeeting.getMeetingLocation());
        }
        reportParams.put("meetingDate", councilMeeting.getMeetingDate().toString() != null ? councilMeeting.getMeetingDate().toString() : " ");
        reportParams.put("meetingTime", councilMeeting.getMeetingTime() != null ? councilMeeting.getMeetingTime() : " ");
        reportParams.put("meetingPlace", councilMeeting.getMeetingLocation() != null ? councilMeeting.getMeetingLocation() : " ");
        reportParams.put("meetingDateTimePlace", meetingDateTimeLocation.toString());
        reportParams.put("cityName", ReportUtil.getCityName());
        return reportParams;
    }

    public ReportOutput createReport(ReportRequest reportRequest) {
        return this.reportService.createReport(reportRequest);
    }
}

