/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service.workflow;

import java.util.Date;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.council.entity.CouncilPreamble;
import org.egov.council.service.workflow.PreambleWorkflowCustom;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PreambleWorkflowCustomImpl
implements PreambleWorkflowCustom {
    private static final Logger LOG = LoggerFactory.getLogger(PreambleWorkflowCustomImpl.class);
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<CouncilPreamble> councilPreambleWorkflowService;
    @Autowired
    private UserService userService;

    @Override
    public void createCommonWorkflowTransition(CouncilPreamble councilPreamble, Long approvalPosition, String approvalComent, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        User currentUser = null;
        Position pos = null;
        Assignment wfInitiator = null;
        String currState = "";
        WorkFlowMatrix wfmatrix = null;
        if (null != councilPreamble.getId()) {
            currentUser = this.userService.getUserById(councilPreamble.getCreatedBy().getId());
            wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(councilPreamble.getCreatedBy().getId());
        }
        if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
            pos = this.positionMasterService.getPositionById(approvalPosition);
        } else {
            Position position = pos = wfInitiator != null ? wfInitiator.getPosition() : null;
        }
        if (null == councilPreamble.getState()) {
            wfmatrix = this.councilPreambleWorkflowService.getWfMatrix(councilPreamble.getStateType(), null, null, null, "NEW", null);
            councilPreamble.setStatus(this.getStatusByPassingModuleAndCode(wfmatrix));
            councilPreamble.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Preamble");
        } else if ("Reject".equalsIgnoreCase(workFlowAction)) {
            councilPreamble.setStatus(this.getStatusByPassingStatusCode("REJECTED"));
            councilPreamble.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask("Preamble");
        } else if ("Approve".equalsIgnoreCase(workFlowAction)) {
            wfmatrix = this.councilPreambleWorkflowService.getWfMatrix(councilPreamble.getStateType(), null, null, null, councilPreamble.getCurrentState().getValue(), null);
            councilPreamble.setStatus(this.getStatusByPassingModuleAndCode(wfmatrix));
            if (wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                councilPreamble.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask("Preamble");
            } else {
                councilPreamble.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Preamble");
            }
        } else if ("Provide more info".equalsIgnoreCase(workFlowAction)) {
            if (ApplicationThreadLocals.getUserId().equals(wfInitiator != null && wfInitiator.getEmployee() != null ? wfInitiator.getEmployee().getId() : 0L)) {
                councilPreamble.setStatus(this.getStatusByPassingStatusCode("REJECTED"));
                councilPreamble.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask("Preamble");
            } else {
                wfmatrix = this.councilPreambleWorkflowService.getWfMatrix(councilPreamble.getStateType(), null, null, null, "Rejected", null);
                councilPreamble.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator != null ? wfInitiator.getPosition() : null).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Preamble");
            }
        } else {
            wfmatrix = this.councilPreambleWorkflowService.getWfMatrix(councilPreamble.getStateType(), null, null, null, councilPreamble.getCurrentState().getValue(), null);
            councilPreamble.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Preamble");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    private EgwStatus getStatusByPassingModuleAndCode(WorkFlowMatrix wfmatrix) {
        return this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", wfmatrix.getNextStatus());
    }

    private EgwStatus getStatusByPassingStatusCode(String statusCode) {
        return this.egwStatusHibernateDAO.getStatusByModuleAndCode("COUNCILPREAMBLE", statusCode);
    }
}

