/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.council.entity.CouncilMember;
import org.egov.council.entity.CouncilMemberStatus;
import org.egov.council.repository.CouncilMemberRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CouncilMemberService {
    private final CouncilMemberRepository councilMemberRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public CouncilMemberService(CouncilMemberRepository councilMemberRepository) {
        this.councilMemberRepository = councilMemberRepository;
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public CouncilMember create(CouncilMember councilMember) {
        return (CouncilMember)((Object)this.councilMemberRepository.save((Object)councilMember));
    }

    @Transactional
    public CouncilMember update(CouncilMember councilMember) {
        return (CouncilMember)((Object)this.councilMemberRepository.save((Object)councilMember));
    }

    public List<CouncilMember> findAll() {
        return this.councilMemberRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public CouncilMember findOne(Long id) {
        return this.councilMemberRepository.findById(id);
    }

    public List<CouncilMember> search(CouncilMember councilMember) {
        Criteria criteria = this.getCurrentSession().createCriteria(CouncilMember.class);
        if (null != councilMember.getElectionWard()) {
            criteria.add((Criterion)Restrictions.eq((String)"electionWard", (Object)councilMember.getElectionWard()));
        }
        if (null != councilMember.getDesignation()) {
            criteria.add((Criterion)Restrictions.eq((String)"designation", (Object)((Object)councilMember.getDesignation())));
        }
        if (null != councilMember.getPartyAffiliation()) {
            criteria.add((Criterion)Restrictions.eq((String)"partyAffiliation", (Object)((Object)councilMember.getPartyAffiliation())));
        }
        if (null != councilMember.getName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)councilMember.getName(), (MatchMode)MatchMode.ANYWHERE));
        }
        return criteria.list();
    }

    public List<CouncilMember> findAllByActive() {
        Criteria criteria = this.getCurrentSession().createCriteria(CouncilMember.class);
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)((Object)CouncilMemberStatus.ACTIVE)));
        criteria.addOrder(Order.asc((String)"name"));
        return criteria.list();
    }
}

