/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.council.entity.CouncilAgenda;
import org.egov.council.entity.CouncilAgendaDetails;
import org.egov.council.repository.CouncilAgendaDetailsRepository;
import org.egov.council.repository.CouncilAgendaRepository;
import org.egov.infra.utils.DateUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CouncilAgendaService {
    private final CouncilAgendaDetailsRepository councilAgendaDetailsRepository;
    private final CouncilAgendaRepository councilAgendaRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public CouncilAgendaService(CouncilAgendaRepository councilAgendaRepository, CouncilAgendaDetailsRepository councilAgendaDetailsRepository) {
        this.councilAgendaRepository = councilAgendaRepository;
        this.councilAgendaDetailsRepository = councilAgendaDetailsRepository;
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public CouncilAgenda create(CouncilAgenda councilAgenda) {
        return (CouncilAgenda)((Object)this.councilAgendaRepository.save((Object)councilAgenda));
    }

    @Transactional
    public CouncilAgenda update(CouncilAgenda councilAgenda) {
        return (CouncilAgenda)((Object)this.councilAgendaRepository.save((Object)councilAgenda));
    }

    @Transactional
    public void deleteAllInBatch(List<CouncilAgendaDetails> existingPreambleList) {
        this.councilAgendaDetailsRepository.deleteInBatch(existingPreambleList);
    }

    public List<CouncilAgenda> findAll() {
        return this.councilAgendaRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"agendaNumber"}));
    }

    public CouncilAgenda findOne(Long id) {
        return this.councilAgendaRepository.findById(id);
    }

    public List<CouncilAgenda> search(CouncilAgenda councilAgenda) {
        return this.buildSearchCriteria(councilAgenda).list();
    }

    public List<CouncilAgenda> searchForAgendaToCreateMeeting(CouncilAgenda councilAgenda) {
        return this.buildSearchCriteria(councilAgenda).add(Restrictions.in((String)"status.code", (Object[])new String[]{"APPROVED", "ADJOURNED"})).list();
    }

    public Criteria buildSearchCriteria(CouncilAgenda councilAgenda) {
        Criteria criteria = this.getCurrentSession().createCriteria(CouncilAgenda.class, "councilAgenda").createAlias("councilAgenda.status", "status");
        if (null != councilAgenda.getStatus()) {
            criteria.add((Criterion)Restrictions.eq((String)"status", (Object)councilAgenda.getStatus().getCode()));
        }
        if (null != councilAgenda.getCommitteeType()) {
            criteria.add((Criterion)Restrictions.eq((String)"committeeType", (Object)((Object)councilAgenda.getCommitteeType())));
        }
        if (councilAgenda.getFromDate() != null && councilAgenda.getToDate() != null) {
            criteria.add(Restrictions.between((String)"councilAgenda.createdDate", (Object)councilAgenda.getFromDate(), (Object)DateUtils.addDays((Date)councilAgenda.getToDate(), (int)1)));
        }
        if (null != councilAgenda.getAgendaNumber()) {
            criteria.add(Restrictions.ilike((String)"councilAgenda.agendaNumber", (String)councilAgenda.getAgendaNumber(), (MatchMode)MatchMode.ANYWHERE));
        }
        return criteria;
    }
}

