/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.autonumber.impl;

import java.io.Serializable;
import java.util.Date;
import org.egov.council.autonumber.MOMResolutionNumberGenerator;
import org.egov.council.entity.MeetingMOM;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MOMResolutionNumberGeneratorImpl
implements MOMResolutionNumberGenerator {
    private static final String MOM_NUMBER_SEQ = "SEQ_EGCNCL_MOM_NUMBER";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;

    @Override
    public String getNextNumber(MeetingMOM meetingMOM) {
        String sequenceName = MOM_NUMBER_SEQ;
        String meetingDate = DateUtils.getDefaultFormattedDate((Date)meetingMOM.getMeeting().getMeetingDate());
        Serializable sequenceNumber = this.applicationSequenceNumberGenerator.getNextSequence(MOM_NUMBER_SEQ);
        String result = String.format("%s-%d", meetingDate, sequenceNumber);
        return result;
    }
}

