/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.council.entity.CouncilQualification;
import org.egov.council.repository.CouncilQualificationRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CouncilQualificationService {
    private final CouncilQualificationRepository councilQualificationRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public CouncilQualificationService(CouncilQualificationRepository councilQualificationRepository) {
        this.councilQualificationRepository = councilQualificationRepository;
    }

    @Transactional
    public CouncilQualification create(CouncilQualification councilQualification) {
        return (CouncilQualification)((Object)this.councilQualificationRepository.save((Object)councilQualification));
    }

    @Transactional
    public CouncilQualification update(CouncilQualification councilQualification) {
        return (CouncilQualification)((Object)this.councilQualificationRepository.save((Object)councilQualification));
    }

    public List<CouncilQualification> findAll() {
        return this.councilQualificationRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public CouncilQualification findOne(Long id) {
        return (CouncilQualification)((Object)this.councilQualificationRepository.findOne(id));
    }

    public List<CouncilQualification> getActiveQualifications() {
        return this.councilQualificationRepository.findByisActive(true);
    }

    public List<CouncilQualification> search(CouncilQualification councilQualification) {
        Criteria criteria = this.getCurrentSession().createCriteria(CouncilQualification.class);
        if (null != councilQualification.getName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)councilQualification.getName(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (councilQualification.getIsActive() != null && councilQualification.getIsActive().booleanValue()) {
            criteria.add((Criterion)Restrictions.eq((String)"isActive", (Object)councilQualification.getIsActive()));
        }
        return criteria.list();
    }
}

