/*
 * Decompiled with CFR 0.152.
 */
package org.egov.council.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.council.entity.CouncilCaste;
import org.egov.council.repository.CouncilCasteRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CouncilCasteService {
    private final CouncilCasteRepository councilCasteRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Autowired
    public CouncilCasteService(CouncilCasteRepository councilCasteRepository) {
        this.councilCasteRepository = councilCasteRepository;
    }

    @Transactional
    public CouncilCaste create(CouncilCaste councilCaste) {
        return (CouncilCaste)((Object)this.councilCasteRepository.save((Object)councilCaste));
    }

    @Transactional
    public CouncilCaste update(CouncilCaste councilCaste) {
        return (CouncilCaste)((Object)this.councilCasteRepository.save((Object)councilCaste));
    }

    public List<CouncilCaste> findAll() {
        return this.councilCasteRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public CouncilCaste findByName(String name) {
        return this.councilCasteRepository.findByName(name);
    }

    public CouncilCaste findOne(Long id) {
        return (CouncilCaste)((Object)this.councilCasteRepository.findOne(id));
    }

    public List<CouncilCaste> getActiveCastes() {
        return this.councilCasteRepository.findByisActive(true);
    }

    public List<CouncilCaste> search(CouncilCaste councilCaste) {
        Criteria criteria = this.getCurrentSession().createCriteria(CouncilCaste.class);
        if (null != councilCaste.getName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)councilCaste.getName(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (councilCaste.getIsActive() != null && councilCaste.getIsActive().booleanValue()) {
            criteria.add((Criterion)Restrictions.eq((String)"isActive", (Object)councilCaste.getIsActive()));
        }
        return criteria.list();
    }
}

