/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.web.controller;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.validation.Valid;
import org.egov.common.entity.Nationality;
import org.egov.commons.service.NationalityService;
import org.egov.commons.web.adaptor.NationalityJsonAdaptor;
import org.egov.infra.utils.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/nationality"})
public class NationalityController {
    private static final String NATIONALITY_NEW = "nationality-new";
    private static final String NATIONALITY_RESULT = "nationality-result";
    private static final String NATIONALITY_EDIT = "nationality-edit";
    private static final String NATIONALITY_VIEW = "nationality-view";
    private static final String NATIONALITY_SEARCH = "nationality-search";
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private NationalityService nationalityService;

    private void prepareNewForm(Model model) {
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("nationality", (Object)new Nationality());
        return NATIONALITY_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Nationality nationality, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            model.addAttribute("mode", (Object)"create");
            return NATIONALITY_NEW;
        }
        this.nationalityService.create(nationality);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.nationality.success", null, Locale.ENGLISH));
        return "redirect:/nationality/result/" + nationality.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        Nationality nationality = this.nationalityService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("nationality", (Object)nationality);
        return NATIONALITY_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Nationality nationality, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return NATIONALITY_EDIT;
        }
        this.nationalityService.update(nationality);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.nationality.success", null, Locale.ENGLISH));
        return "redirect:/nationality/result/" + nationality.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        Nationality nationality = this.nationalityService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("nationality", (Object)nationality);
        return NATIONALITY_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        Nationality nationality = this.nationalityService.findOne(id);
        model.addAttribute("nationality", (Object)nationality);
        return NATIONALITY_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        Nationality nationality = new Nationality();
        this.prepareNewForm(model);
        model.addAttribute("nationality", (Object)nationality);
        return NATIONALITY_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearchRegistrationunit(@PathVariable(value="mode") String mode, Model model, @ModelAttribute Nationality nationality) {
        List searchResultList = this.nationalityService.search(nationality);
        String result = "{ \"data\":" + JsonUtils.toJSON((Collection)searchResultList, Nationality.class, NationalityJsonAdaptor.class) + "}";
        return result;
    }
}

