/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.web.controller;

import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.RandomStringUtils;
import org.egov.common.entity.EducationalQualification;
import org.egov.commons.service.EducationalQualificationService;
import org.egov.commons.web.adaptor.EducationalQualificationJsonAdaptor;
import org.egov.infra.utils.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/qualification"})
public class EducationalQualificationController {
    private static final String EDUCATIONAL_QUALIFICATION = "educationalQualification";
    private static final String QUALIFICATION_NEW = "qualification-new";
    private static final String QUALIFICATION_RESULT = "qualification-result";
    private static final String QUALIFICATION_EDIT = "qualification-edit";
    private static final String QUALIFICATION_VIEW = "qualification-view";
    private static final String QUALIFICATION_SEARCH = "qualification-search";
    @Autowired
    private EducationalQualificationService qualificationService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        EducationalQualification qualification = new EducationalQualification();
        qualification.setCode(RandomStringUtils.random((int)4, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE).toUpperCase());
        model.addAttribute(EDUCATIONAL_QUALIFICATION, (Object)qualification);
        return QUALIFICATION_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute EducationalQualification educationalQualification, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (educationalQualification != null && educationalQualification.getCode() == null) {
            educationalQualification.setCode(RandomStringUtils.random((int)4, (boolean)Boolean.TRUE, (boolean)Boolean.TRUE).toUpperCase());
        }
        if (errors.hasErrors()) {
            return QUALIFICATION_NEW;
        }
        this.qualificationService.create(educationalQualification);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.educational.qualification.success", null, null));
        return "redirect:/qualification/result/" + educationalQualification.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        EducationalQualification educationalQualification = this.qualificationService.findOne(id);
        model.addAttribute(EDUCATIONAL_QUALIFICATION, (Object)educationalQualification);
        return QUALIFICATION_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute EducationalQualification educationalQualification, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            model.addAttribute(EDUCATIONAL_QUALIFICATION, (Object)educationalQualification);
            return QUALIFICATION_EDIT;
        }
        this.qualificationService.update(educationalQualification);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.educational.qualification.success", null, null));
        return "redirect:/qualification/result/" + educationalQualification.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        EducationalQualification educationalQualification = this.qualificationService.findOne(id);
        model.addAttribute(EDUCATIONAL_QUALIFICATION, (Object)educationalQualification);
        return QUALIFICATION_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        EducationalQualification educationalQualification = this.qualificationService.findOne(id);
        model.addAttribute(EDUCATIONAL_QUALIFICATION, (Object)educationalQualification);
        return QUALIFICATION_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        EducationalQualification educationalQualification = new EducationalQualification();
        model.addAttribute(EDUCATIONAL_QUALIFICATION, (Object)educationalQualification);
        return QUALIFICATION_SEARCH;
    }

    @RequestMapping(value={"/searchresult/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute EducationalQualification educationalQualification) {
        List searchResultList = this.qualificationService.search(educationalQualification);
        return "{ \"data\":" + JsonUtils.toJSON((Collection)searchResultList, EducationalQualification.class, EducationalQualificationJsonAdaptor.class) + "}";
    }
}

