/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Locale;
import javax.validation.Valid;
import org.egov.common.entity.UOMCategory;
import org.egov.commons.service.UOMCategoryService;
import org.egov.commons.web.adaptor.UOMCategoryJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/uomcategory"})
public class UOMCategoryController {
    private static final String UOMCATEGORY_NEW = "uomcategory-new";
    private static final String UOMCATEGORY_RESULT = "uomcategory-result";
    private static final String UOMCATEGORY_EDIT = "uomcategory-edit";
    private static final String UOMCATEGORY_VIEW = "uomcategory-view";
    private static final String UOMCATEGORY_SEARCH = "uomcategory-search";
    @Autowired
    private UOMCategoryService uomCategoryService;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("UOMCategory", (Object)new UOMCategory());
        return UOMCATEGORY_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute UOMCategory uomCategory, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            model.addAttribute("mode", (Object)"create");
            return UOMCATEGORY_NEW;
        }
        this.uomCategoryService.create(uomCategory);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.uomCategory.success", null, Locale.ENGLISH));
        return "redirect:/uomcategory/result/" + uomCategory.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        UOMCategory uomCategory = this.uomCategoryService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("UOMCategory", (Object)uomCategory);
        return UOMCATEGORY_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute UOMCategory uomCategory, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return UOMCATEGORY_EDIT;
        }
        this.uomCategoryService.update(uomCategory);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.uomCategory.success", null, Locale.ENGLISH));
        return "redirect:/uomcategory/result/" + uomCategory.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        UOMCategory uomCategory = this.uomCategoryService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("UOMCategory", (Object)uomCategory);
        return UOMCATEGORY_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        UOMCategory uomCategory = this.uomCategoryService.findOne(id);
        model.addAttribute("UOMCategory", (Object)uomCategory);
        return UOMCATEGORY_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        UOMCategory uomCategory = new UOMCategory();
        model.addAttribute("categories", (Object)this.uomCategoryService.findAll());
        this.prepareNewForm(model);
        model.addAttribute("UOMCategory", (Object)uomCategory);
        if (mode.equals("view")) {
            return UOMCATEGORY_VIEW;
        }
        return UOMCATEGORY_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute UOMCategory uomCategory) {
        List searchResultList = this.uomCategoryService.search(uomCategory);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(UOMCategory.class, (Object)new UOMCategoryJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

