/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.web.controller;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import javax.validation.Valid;
import org.egov.common.entity.UOM;
import org.egov.commons.service.UOMCategoryService;
import org.egov.commons.service.UOMService;
import org.egov.commons.web.adaptor.UOMJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/uom"})
public class UOMController {
    private static final String UOM_NEW = "uom-new";
    private static final String UOM_RESULT = "uom-result";
    private static final String UOM_EDIT = "uom-edit";
    private static final String UOM_VIEW = "uom-view";
    private static final String UOM_SEARCH = "uom-search";
    @Autowired
    private UOMService uomService;
    @Autowired
    private UOMCategoryService uomCategoryService;
    @Autowired
    private MessageSource messageSource;

    private void prepareNewForm(Model model) {
        model.addAttribute("categories", (Object)this.uomCategoryService.findAll());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public String newForm(Model model) {
        this.prepareNewForm(model);
        model.addAttribute("UOM", (Object)new UOM());
        model.addAttribute("mode", (Object)"create");
        return UOM_NEW;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute UOM uom, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return UOM_NEW;
        }
        this.uomService.create(uom);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.uom.success", null, null));
        return "redirect:/uom/result/" + uom.getId();
    }

    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable(value="id") Long id, Model model) {
        UOM uom = this.uomService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("UOM", (Object)uom);
        model.addAttribute("mode", (Object)"edit");
        return UOM_EDIT;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute UOM uom, BindingResult errors, Model model, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            this.prepareNewForm(model);
            return UOM_EDIT;
        }
        this.uomService.update(uom);
        redirectAttrs.addFlashAttribute("message", (Object)this.messageSource.getMessage("msg.uom.success", null, null));
        return "redirect:/uom/result/" + uom.getId();
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@PathVariable(value="id") Long id, Model model) {
        UOM uom = this.uomService.findOne(id);
        this.prepareNewForm(model);
        model.addAttribute("UOM", (Object)uom);
        return UOM_VIEW;
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String result(@PathVariable(value="id") Long id, Model model) {
        UOM uom = this.uomService.findOne(id);
        model.addAttribute("UOM", (Object)uom);
        return UOM_RESULT;
    }

    @RequestMapping(value={"/search/{mode}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="mode") String mode, Model model) {
        UOM uom = new UOM();
        model.addAttribute("unitOfMeasurement", (Object)this.uomService.findAll());
        this.prepareNewForm(model);
        model.addAttribute("UOM", (Object)uom);
        return UOM_SEARCH;
    }

    @RequestMapping(value={"/ajaxsearch/{mode}"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(@PathVariable(value="mode") String mode, Model model, @ModelAttribute UOM uom) {
        List searchResultList = this.uomService.search(uom);
        String result = "{ \"data\":" + this.toSearchResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(UOM.class, (Object)new UOMJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }
}

