/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lib.rrbac.filter;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.admin.master.entity.Action;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.ActionService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.exception.AuthorizationException;
import org.egov.infra.script.entity.Script;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infstr.services.PersistenceService;
import org.egov.lib.rrbac.model.AuthorizationRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RuleInterceptorFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleInterceptorFilter.class);
    private PersistenceService daoService;
    private PersistenceService<AuthorizationRule, Long> authRuleService;
    @Autowired
    private ActionService actionService;
    @Autowired
    private ScriptService scriptExecuter;
    @Autowired
    private SecurityUtils securityUtils;

    public void init(FilterConfig config) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("In RuleInterceptorFilter init");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getParameter("AUTHRULE_OBJECT_ID") != null) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            Action action = this.getAction(httpRequest);
            List authRuleList = this.authRuleService.findAllByNamedQuery("authRulesByAction", new Object[]{action});
            for (AuthorizationRule authRule : authRuleList) {
                Object object = this.getEntity(httpRequest, authRule);
                List authResList = this.getRuleAuthentication(this.securityUtils.getCurrentUser(), authRule, object);
                boolean authorized = Boolean.valueOf(authResList.get(0).toString());
                if (authorized) continue;
                request.setAttribute("AuthRuleErrMsgKey", (Object)authResList.get(1).toString());
                throw new AuthorizationException(authResList.get(1).toString());
            }
        }
        chain.doFilter(request, response);
    }

    private List getRuleAuthentication(User currUser, AuthorizationRule authRule, Object object) {
        return (List)this.scriptExecuter.executeScript(authRule.getScript().getName(), ScriptService.createContext((Object[])new Object[]{"object", object, "user", currUser}));
    }

    public void destroy() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("In RuleInterceptorFilter Destroy");
        }
    }

    private Action getAction(HttpServletRequest request) {
        Action action;
        String actionId = request.getParameter("actionid");
        if (actionId == null || actionId.length() == 0) {
            String contextPath = request.getContextPath();
            String requestURI = StringUtils.remove((String)request.getRequestURI(), (String)contextPath);
            action = this.actionService.getActionByUrlAndContextRoot(requestURI, StringUtils.remove((String)contextPath, (char)'/'));
        } else {
            action = this.actionService.getActionById(Long.valueOf(actionId));
        }
        return action;
    }

    private Object getEntity(HttpServletRequest httpRequest, AuthorizationRule authRule) {
        Long objectId = Long.valueOf(httpRequest.getParameter("AUTHRULE_OBJECT_ID"));
        List objects = this.daoService.findAllBy("from " + authRule.getObjectType() + " where id=?", new Object[]{objectId});
        if (objects.isEmpty()) {
            throw new ApplicationRuntimeException("Object id is null to get AuthorizationRule");
        }
        return objects.get(0);
    }

    public void setDaoService(PersistenceService<Script, Long> daoService) {
        this.daoService = daoService;
    }

    public void setAuthRuleService(PersistenceService<AuthorizationRule, Long> authRuleService) {
        this.authRuleService = authRuleService;
    }
}

