/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.commons.service.EntityTypeService;
import org.egov.commons.utils.EntityType;
import org.egov.eis.entity.DrawingOfficer;
import org.egov.eis.repository.DrawingOfficerRepository;
import org.egov.infra.validation.exception.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DrawingOfficerService
implements EntityTypeService {
    private final DrawingOfficerRepository drawingOfficerRepository;

    @Autowired
    public DrawingOfficerService(DrawingOfficerRepository drawingOfficerRepository) {
        this.drawingOfficerRepository = drawingOfficerRepository;
    }

    public List<DrawingOfficer> getAllDrawingOfficers() {
        return this.drawingOfficerRepository.findAll();
    }

    public DrawingOfficer findById(Long id) {
        return (DrawingOfficer)this.drawingOfficerRepository.findOne(id);
    }

    public DrawingOfficer getDrawingOfficerByName(String name) {
        return this.drawingOfficerRepository.findByName(name);
    }

    public DrawingOfficer getDrawingOfficerByCode(String code) {
        return this.drawingOfficerRepository.findByCode(code);
    }

    public DrawingOfficer getDrawingOfficerByPosition(Long posId) {
        return this.drawingOfficerRepository.findByPosition_Id(posId);
    }

    public List<DrawingOfficer> getListOfDrawingOfficersByNameLike(String name) {
        return this.drawingOfficerRepository.findByNameContainingIgnoreCase(name);
    }

    public List<DrawingOfficer> getListOfDrawingOfficerByCodeLike(String code) {
        return this.drawingOfficerRepository.findByCodeContainingIgnoreCase(code);
    }

    @Transactional
    public void create(DrawingOfficer officer) {
        this.drawingOfficerRepository.save(officer);
    }

    @Transactional
    public void update(DrawingOfficer officer) {
        this.drawingOfficerRepository.save(officer);
    }

    @Transactional
    public void delete(DrawingOfficer officer) {
        this.drawingOfficerRepository.delete(officer);
    }

    public List<EntityType> getAllActiveEntities(Integer accountDetailTypeId) {
        ArrayList<EntityType> entities = new ArrayList<EntityType>();
        List<DrawingOfficer> drawingOfficers = this.getAllDrawingOfficers();
        entities.addAll(drawingOfficers);
        return entities;
    }

    @Override
    public List<? extends EntityType> filterActiveEntities(String filterKey, int maxRecords, Integer accountDetailTypeId) {
        return this.drawingOfficerRepository.findByNameLikeOrCodeLike(filterKey + "%", filterKey + "%");
    }

    @Override
    public List getAssetCodesForProjectCode(Integer accountdetailkey) throws ValidationException {
        return null;
    }

    public List<EntityType> validateEntityForRTGS(List<Long> idsList) throws ValidationException {
        return null;
    }

    public List<EntityType> getEntitiesById(List<Long> idsList) throws ValidationException {
        return null;
    }
}

