/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.common.entity.EducationalQualification;
import org.egov.commons.repository.EducationalQualificationRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EducationalQualificationService {
    private final EducationalQualificationRepository qualificationRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public EducationalQualificationService(EducationalQualificationRepository qualificationRepository) {
        this.qualificationRepository = qualificationRepository;
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public EducationalQualification create(EducationalQualification qualification) {
        return (EducationalQualification)((Object)this.qualificationRepository.save((Object)qualification));
    }

    @Transactional
    public EducationalQualification update(EducationalQualification qualification) {
        return (EducationalQualification)((Object)this.qualificationRepository.save((Object)qualification));
    }

    public List<EducationalQualification> findAll() {
        return this.qualificationRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public EducationalQualification findOne(Long id) {
        return (EducationalQualification)((Object)this.qualificationRepository.findOne(id));
    }

    public List<EducationalQualification> getActiveQualifications() {
        return this.qualificationRepository.findByisActive(true);
    }

    public List<EducationalQualification> search(EducationalQualification qualification) {
        Criteria criteria = this.getCurrentSession().createCriteria(EducationalQualification.class);
        if (null != qualification.getName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)qualification.getName(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (qualification.getIsActive() != null && qualification.getIsActive().booleanValue()) {
            criteria.add((Criterion)Restrictions.eq((String)"isActive", (Object)qualification.getIsActive()));
        }
        return criteria.list();
    }
}

