/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Functionary;
import org.egov.commons.dao.FunctionaryDAO;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FunctionaryHibernateDAO
extends FunctionaryDAO {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    @Transactional
    public Functionary update(Functionary entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public Functionary create(Functionary entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public void delete(Functionary entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    @Override
    public Functionary findById(Number id, boolean lock) {
        return (Functionary)this.getCurrentSession().load(Functionary.class, (Serializable)id);
    }

    @Override
    public List<Functionary> findAll() {
        return this.getCurrentSession().createCriteria(Functionary.class).list();
    }

    @Override
    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List findAllActiveFunctionary() {
        return this.getCurrentSession().createQuery("from Functionary f where isactive=true order by code").list();
    }

    @Override
    public Functionary functionaryById(Integer id) {
        return (Functionary)this.getCurrentSession().get(Functionary.class, (Serializable)id);
    }

    public Functionary getFunctionaryByCode(BigDecimal functionaryCode) {
        Query qry = this.getCurrentSession().createQuery("from Functionary where code=:code");
        qry.setBigDecimal("code", functionaryCode);
        return (Functionary)qry.uniqueResult();
    }

    public Functionary getFunctionaryByName(String name) {
        Query qry = this.getCurrentSession().createQuery("from Functionary where name=:name");
        qry.setString("name", name);
        return (Functionary)qry.uniqueResult();
    }
}

