/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Bankaccount;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BankaccountHibernateDAO {
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public Bankaccount update(Bankaccount entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Transactional
    public Bankaccount create(Bankaccount entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Transactional
    public void delete(Bankaccount entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    public Bankaccount findById(Number id, boolean lock) {
        return (Bankaccount)this.getCurrentSession().load(Bankaccount.class, (Serializable)id);
    }

    public List<Bankaccount> findAll() {
        return this.getCurrentSession().createCriteria(Bankaccount.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<Bankaccount> getAllBankAccounts() {
        return this.getCurrentSession().createQuery("from Bankaccount BA order by BA.accountnumber").list();
    }

    public Bankaccount getBankAccountByAccBranchBank(String bankAccNum, String bankBranchCode, String bankCode) {
        Query qry = this.getCurrentSession().createQuery("from Bankaccount bankacc where bankacc.accountnumber=:accNum  and bankacc.bankbranch.branchcode=:branchCode and bankacc.bankbranch.bank.code=:bankCode");
        qry.setString("accNum", bankAccNum);
        qry.setString("branchCode", bankBranchCode);
        qry.setString("bankCode", bankCode);
        Bankaccount bankAccount = null;
        if (qry.list().size() != 0) {
            bankAccount = (Bankaccount)qry.list().get(0);
        }
        return bankAccount;
    }

    public List<Bankaccount> getBankAccountByBankBranch(Integer bankBranchId) {
        Query qry = this.getCurrentSession().createQuery("from Bankaccount bankacc where bankacc.isactive=true and bankacc.bankbranch.id=:bankBranchId ");
        qry.setInteger("bankBranchId", bankBranchId.intValue());
        List bankAccount = null;
        if (qry.list().size() != 0) {
            bankAccount = qry.list();
        }
        return bankAccount;
    }

    public List<Bankaccount> getBankAccountByBankBranchForReceiptsPayments(Integer bankBranchId, Integer fundId) {
        StringBuilder query = new StringBuilder("from Bankaccount bankacc where bankacc.isactive=true and bankacc.type in ('RECEIPTS_PAYMENTS','RECEIPTS') and bankacc.bankbranch.id=:bankBranchId");
        if (fundId != null) {
            query.append(" and bankacc.fund.id=:fundId");
        }
        Query qry = this.getCurrentSession().createQuery(query.toString());
        qry.setInteger("bankBranchId", bankBranchId.intValue());
        if (fundId != null) {
            qry.setInteger("fundId", fundId.intValue());
        }
        List bankAccount = null;
        if (qry.list().size() != 0) {
            bankAccount = qry.list();
        }
        return bankAccount;
    }
}

