/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class ChartOfAccountsService
extends PersistenceService<CChartOfAccounts, Long> {
    private static final String PURPOSE_ID = "purposeId";
    private static final String CONTINGENCY_BILL_PURPOSE_IDS = "contingencyBillPurposeIds";
    private static final String GLCODE = "glcode";
    @Autowired
    protected AppConfigValueService appConfigValuesService;

    public ChartOfAccountsService(Class<CChartOfAccounts> type) {
        super(type);
    }

    public List<CChartOfAccounts> getActiveCodeList() {
        return this.findAllBy("select acc from CChartOfAccounts acc where acc.isActiveForPosting=true order by acc.glcode", new Object[0]);
    }

    public List<CChartOfAccounts> getAllAccountCodes(String glcode) {
        Query entitysQuery = this.getSession().createQuery(" from CChartOfAccounts a where a.isActiveForPosting=true and a.classification=4 and (a.glcode like :glcode or lower(a.name) like :name) order by a.glcode");
        entitysQuery.setString(GLCODE, glcode + "%");
        entitysQuery.setString("name", glcode.toLowerCase() + "%");
        return entitysQuery.list();
    }

    @Transactional
    public void updateActiveForPostingByMaterializedPath(String materializedPath) {
        this.getSession().createSQLQuery("update chartofaccounts set isactiveforposting = true where isactiveforposting = false and id in (select distinct bg.mincode from egf_budgetgroup bg,egf_budgetdetail bd where bd.budgetgroup = bg.id  and bd.materializedpath like'" + materializedPath + "%') ").executeUpdate();
    }

    public List<CChartOfAccounts> getSubledgerAccountCodesForAccountDetailTypeAndNonSubledgers(Integer accountDetailTypeId, String glcode) {
        Query entitysQuery;
        List configValuesByModuleAndKey = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", CONTINGENCY_BILL_PURPOSE_IDS);
        ArrayList<Long> contingencyBillPurposeIds = new ArrayList<Long>();
        for (AppConfigValues av : configValuesByModuleAndKey) {
            contingencyBillPurposeIds.add(Long.valueOf(av.getValue()));
        }
        if (accountDetailTypeId == 0 || accountDetailTypeId == -1) {
            entitysQuery = this.getSession().createQuery(" from CChartOfAccounts a where a.isActiveForPosting=true and a.classification=4 and size(a.chartOfAccountDetails) = 0 and (glcode like :glcode or lower(name) like :name) and (purposeId is null or purposeId not in (:ids)) order by a.id");
            entitysQuery.setString(GLCODE, glcode + "%");
            entitysQuery.setString("name", glcode.toLowerCase() + "%");
            entitysQuery.setParameterList("ids", contingencyBillPurposeIds);
            return entitysQuery.list();
        }
        entitysQuery = this.getSession().createQuery(" from CChartOfAccounts  a LEFT OUTER JOIN  fetch a.chartOfAccountDetails  b where (size(a.chartOfAccountDetails) = 0 or b.detailTypeId.id=:accountDetailTypeId)and a.isActiveForPosting=true and a.classification=4 and (a.glcode like :glcode or lower(a.name) like :name) and (purposeId is null or purposeId not in (:ids)) order by a.id");
        entitysQuery.setInteger("accountDetailTypeId", accountDetailTypeId.intValue());
        entitysQuery.setString(GLCODE, glcode + "%");
        entitysQuery.setString("name", glcode.toLowerCase() + "%");
        entitysQuery.setParameterList("ids", contingencyBillPurposeIds);
        return entitysQuery.list();
    }

    public List<CChartOfAccounts> getAccountCodeByPurpose(Integer purposeId) {
        ArrayList<CChartOfAccounts> accountCodeList = new ArrayList<CChartOfAccounts>();
        try {
            if (purposeId == null || purposeId == 0) {
                throw new ApplicationException("Purpose Id is null or zero");
            }
            Query query = this.getSession().createQuery(" from EgfAccountcodePurpose purpose where purpose.id=" + purposeId + "");
            if (query.list().isEmpty()) {
                throw new ApplicationException("Purpose ID provided is not defined in the system");
            }
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE purposeid=:purposeId))) AND classification=4 AND isActiveForPosting=true ");
            query.setLong(PURPOSE_ID, (long)purposeId.intValue());
            accountCodeList.addAll(query.list());
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE purposeid=:purposeId)) AND classification=4 AND isActiveForPosting=true ");
            query.setLong(PURPOSE_ID, (long)purposeId.intValue());
            accountCodeList.addAll(query.list());
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE purposeid=:purposeId) AND classification=4 AND isActiveForPosting=true ");
            query.setLong(PURPOSE_ID, (long)purposeId.intValue());
            accountCodeList.addAll(query.list());
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE purposeid=:purposeId AND classification=4 AND isActiveForPosting=true ");
            query.setLong(PURPOSE_ID, (long)purposeId.intValue());
            accountCodeList.addAll(query.list());
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while getting Account Code by purpose", (Throwable)e);
        }
        return accountCodeList;
    }

    public List<CChartOfAccounts> getAccountCodeByPurposeName(String purposeName) {
        ArrayList<CChartOfAccounts> accountCodeList = new ArrayList<CChartOfAccounts>();
        try {
            if (purposeName == null || purposeName.equalsIgnoreCase("")) {
                throw new ApplicationException("Purpose Name is null or empty");
            }
            Query query = this.getSession().createQuery(" from EgfAccountcodePurpose purpose where purpose.name='" + purposeName + "'");
            if (query.list().size() == 0) {
                throw new ApplicationException("Purpose Name provided is not defined in the system");
            }
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT coa.id FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId=purpose.id and purpose.name = :purposeName))) AND classification=4 AND isActiveForPosting=true ");
            query.setString("purposeName", purposeName);
            accountCodeList.addAll(query.list());
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT coa.id FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId=purpose.id and purpose.name = :purposeName)) AND classification=4 AND isActiveForPosting=true ");
            query.setString("purposeName", purposeName);
            accountCodeList.addAll(query.list());
            query = this.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT coa.id FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId=purpose.id and purpose.name = :purposeName) AND classification=4 AND isActiveForPosting=true ");
            query.setString("purposeName", purposeName);
            accountCodeList.addAll(query.list());
            query = this.getSession().createQuery("SELECT coa FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId=purpose.id and purpose.name = :purposeName AND coa.classification=4 AND coa.isActiveForPosting=true ");
            query.setString("purposeName", purposeName);
            accountCodeList.addAll(query.list());
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while getting Account Code by purpose name", (Throwable)e);
        }
        return accountCodeList;
    }

    public List<CChartOfAccounts> getNetPayableCodesByAccountDetailType(Integer accountDetailType) {
        List configValuesByModuleAndKey = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", CONTINGENCY_BILL_PURPOSE_IDS);
        HashSet<CChartOfAccounts> netPayList = new HashSet<CChartOfAccounts>();
        List<Object> accountCodeByPurpose = new ArrayList();
        for (int i = 0; i < configValuesByModuleAndKey.size(); ++i) {
            try {
                accountCodeByPurpose = this.getAccountCodeByPurpose(Integer.valueOf(((AppConfigValues)configValuesByModuleAndKey.get(i)).getValue()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (accountDetailType == null || accountDetailType == 0) {
                for (CChartOfAccounts coa : accountCodeByPurpose) {
                    if (!coa.getChartOfAccountDetails().isEmpty()) continue;
                    netPayList.add(coa);
                }
                continue;
            }
            for (CChartOfAccounts coa : accountCodeByPurpose) {
                if (!coa.getChartOfAccountDetails().isEmpty()) {
                    for (CChartOfAccountDetail coaDtl : coa.getChartOfAccountDetails()) {
                        if (coaDtl.getDetailTypeId() == null || !coaDtl.getDetailTypeId().getId().equals(accountDetailType)) continue;
                        netPayList.add(coa);
                    }
                }
                netPayList.add(coa);
            }
        }
        return new ArrayList<CChartOfAccounts>(netPayList);
    }

    public List<CChartOfAccounts> getNetPayableCodes() {
        List configValuesByModuleAndKey = this.appConfigValuesService.getConfigValuesByModuleAndKey("EGF", CONTINGENCY_BILL_PURPOSE_IDS);
        HashSet<CChartOfAccounts> netPayList = new HashSet<CChartOfAccounts>();
        List<Object> accountCodeByPurpose = new ArrayList();
        for (int i = 0; i < configValuesByModuleAndKey.size(); ++i) {
            try {
                accountCodeByPurpose = this.getAccountCodeByPurpose(Integer.valueOf(((AppConfigValues)configValuesByModuleAndKey.get(i)).getValue()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (CChartOfAccounts coa : accountCodeByPurpose) {
                netPayList.add(coa);
            }
        }
        return new ArrayList<CChartOfAccounts>(netPayList);
    }

    public List<CChartOfAccounts> getAccountTypes() {
        Query accountTypesQuery = this.getSession().createQuery(" from CChartOfAccounts WHERE glcode LIKE '4502%' AND classification=2 ORDER BY glcode");
        return accountTypesQuery.list();
    }

    public CChartOfAccounts getByGlCodeDesc(String glcode) {
        Query query = this.getSession().createQuery(" from CChartOfAccounts a where  a.glcode like :glcode  order by a.glcode desc");
        query.setString(GLCODE, glcode + "%");
        List resultList = query.list();
        return resultList.isEmpty() ? null : (CChartOfAccounts)((Object)resultList.get(0));
    }

    public CChartOfAccounts getByGlCode(String glcode) {
        Query query = this.getSession().createQuery(" from CChartOfAccounts a where  a.glcode =:glcode ");
        query.setString(GLCODE, glcode);
        List resultList = query.list();
        return resultList.isEmpty() ? null : (CChartOfAccounts)((Object)resultList.get(0));
    }

    public CChartOfAccounts getById(Long id) {
        return (CChartOfAccounts)((Object)this.getSession().load(CChartOfAccounts.class, (Serializable)id));
    }

    public List<CChartOfAccounts> getAllAccountCodesByIsactiveAndClassification() {
        Query query = this.getSession().createQuery(" from CChartOfAccounts coa where coa.isActiveForPosting=true and coa.classification=4");
        return query.list();
    }
}

