/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFiscalPeriod;
import org.egov.commons.repository.CFinancialYearRepository;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CFinancialYearService {
    private final CFinancialYearRepository cFinancialYearRepository;

    @Autowired
    public CFinancialYearService(CFinancialYearRepository cFinancialYearRepository) {
        this.cFinancialYearRepository = cFinancialYearRepository;
    }

    @Transactional
    public CFinancialYear create(CFinancialYear cFinancialYear) {
        return (CFinancialYear)((Object)this.cFinancialYearRepository.save((Object)cFinancialYear));
    }

    @Transactional
    public CFinancialYear update(CFinancialYear cFinancialYear) {
        return (CFinancialYear)((Object)this.cFinancialYearRepository.save((Object)cFinancialYear));
    }

    public List<CFinancialYear> findAll() {
        return this.cFinancialYearRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"finYearRange"}));
    }

    public List<CFinancialYear> getAllFinancialYears() {
        return this.cFinancialYearRepository.getAllFinancialYears();
    }

    public CFinancialYear findOne(Long id) {
        return (CFinancialYear)((Object)this.cFinancialYearRepository.findOne(id));
    }

    public List<CFinancialYear> search(CFinancialYear cFinancialYear) {
        if (cFinancialYear.getFinYearRange() != null) {
            return this.cFinancialYearRepository.findByFinancialYearRange(cFinancialYear.getFinYearRange());
        }
        return this.findAll();
    }

    public Date getNextFinancialYearStartingDate() {
        List<CFinancialYear> cFinYear = this.cFinancialYearRepository.getFinYearLastDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(cFinYear.get(0).getEndingDate());
        cal.add(5, 1);
        return cal.getTime();
    }

    public CFiscalPeriod findByFiscalName(String name) {
        return this.cFinancialYearRepository.findByFiscalName(name);
    }

    public CFinancialYear getFinancialYearByDate(Date date) {
        return this.cFinancialYearRepository.getFinancialYearByDate(date);
    }

    public List<CFinancialYear> getFinancialYearNotClosed() {
        return this.cFinancialYearRepository.findByIsClosedFalseOrderByFinYearRangeDesc();
    }

    public CFinancialYear getFinacialYearByYearRange(String finYearRange) {
        return this.cFinancialYearRepository.findByFinYearRange(finYearRange);
    }

    public List<CFinancialYear> getFinancialYears(List<Long> financialYearList) {
        return this.cFinancialYearRepository.findByIdIn(financialYearList);
    }

    public CFinancialYear getPreviousFinancialYearForDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -1);
        return this.cFinancialYearRepository.getFinancialYearByDate(cal.getTime());
    }

    public CFinancialYear getCurrentFinancialYear() {
        return this.getFinancialYearByDate(new Date());
    }

    public CFinancialYear getLatestFinancialYear() {
        return this.getFinancialYearByDate(new DateTime().withMonthOfYear(4).withDayOfMonth(1).toDate());
    }
}

