/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.ObjectType;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.hibernate.Query;
import org.hibernate.Session;

public class ObjectTypeDAO {
    @PersistenceContext
    private EntityManager entityManager;

    private Session getSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public void createObjectType(ObjectType objectType) {
        try {
            this.getSession().save((Object)objectType);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while creating Object Type", (Throwable)e);
        }
    }

    public void updateObjectType(ObjectType objectType) {
        try {
            this.getSession().saveOrUpdate((Object)objectType);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while updating Object Type", (Throwable)e);
        }
    }

    public void removeObjectType(ObjectType objectType) {
        try {
            this.getSession().delete((Object)objectType);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while deleting Object Type", (Throwable)e);
        }
    }

    public ObjectType getObjectType(int objType) {
        try {
            return (ObjectType)this.getSession().get(ObjectType.class, (Serializable)new Integer(objType));
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while getting Object Type", (Throwable)e);
        }
    }

    public ObjectType getObjectType(String objTypeName) {
        Query qry = this.getSession().createQuery("from ObjectType D where D.type =:objTypeName ");
        qry.setString("objTypeName", objTypeName);
        return (ObjectType)qry.uniqueResult();
    }
}

