/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Fundsource;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FundSourceHibernateDAO {
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public Fundsource update(Fundsource entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Transactional
    public Fundsource create(Fundsource entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Transactional
    public void delete(Fundsource entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    public Fundsource findById(Number id, boolean lock) {
        return (Fundsource)((Object)this.getCurrentSession().load(Fundsource.class, (Serializable)id));
    }

    public List<Fundsource> findAll() {
        return this.getCurrentSession().createCriteria(Fundsource.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Fundsource fundsourceById(Integer id) {
        return (Fundsource)((Object)this.getCurrentSession().get(Fundsource.class, (Serializable)id));
    }

    public List<Fundsource> findAllActiveIsLeafFundSources() {
        return this.getCurrentSession().createQuery("from org.egov.commons.Fundsource where isactive = true  order by name").list();
    }

    public Fundsource getFundSourceByCode(String code) {
        Query query = this.getCurrentSession().createQuery("from Fundsource f where f.code=:code");
        query.setString("code", code);
        return (Fundsource)((Object)query.uniqueResult());
    }
}

