/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.dao.ChartOfAccountsDAO;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class ChartOfAccountsHibernateDAO
implements ChartOfAccountsDAO {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @PersistenceContext
    private EntityManager entityManager;
    private static final Logger LOG = Logger.getLogger(ChartOfAccountsHibernateDAO.class);

    @Override
    @Transactional
    public CChartOfAccounts update(CChartOfAccounts entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public CChartOfAccounts create(CChartOfAccounts entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public void delete(CChartOfAccounts entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    @Override
    public CChartOfAccounts findById(Number id, boolean lock) {
        return (CChartOfAccounts)((Object)this.getCurrentSession().load(CChartOfAccounts.class, (Serializable)id));
    }

    @Override
    public List<CChartOfAccounts> findAll() {
        return this.getCurrentSession().createCriteria(CChartOfAccounts.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    @Deprecated
    public Collection getAccountCodeListForDetails() {
        return this.getCurrentSession().createQuery("select acc from CChartOfAccounts acc where acc.classification='4' and acc.isActiveForPosting=true order by acc.glcode").list();
    }

    @Override
    public List<CChartOfAccounts> getDetailedAccountCodeList() {
        return this.getCurrentSession().createQuery("select acc from CChartOfAccounts acc where acc.classification='4' and acc.isActiveForPosting=true order by acc.glcode").setCacheable(true).list();
    }

    public List<CChartOfAccounts> getDetailedCodesList() {
        return this.getCurrentSession().createQuery("from CChartOfAccounts where classification=4").setCacheable(true).list();
    }

    public List<CChartOfAccounts> findDetailedAccountCodesByGlcodeOrNameLike(String searchString) {
        Query qry = this.getCurrentSession().createQuery("from CChartOfAccounts where classification='4' and isActiveForPosting=true and (glcode like :glCode or upper(name) like :name) order by glcode");
        qry.setString("glCode", searchString + "%");
        qry.setString("name", "%" + searchString.toUpperCase() + "%");
        return qry.list();
    }

    @Override
    @Deprecated
    public CChartOfAccounts findCodeByPurposeId(int purposeId) {
        Query qry = this.getCurrentSession().createQuery("select acc from CChartOfAccounts acc where acc.purposeId=:purposeId ");
        qry.setLong("purposeId", (long)purposeId);
        return (CChartOfAccounts)((Object)qry.uniqueResult());
    }

    @Override
    public CChartOfAccounts getCChartOfAccountsByGlCode(String glCode) {
        Query qry = this.getCurrentSession().createQuery("from CChartOfAccounts coa where coa.glcode =:glCode");
        qry.setString("glCode", glCode);
        return (CChartOfAccounts)((Object)qry.uniqueResult());
    }

    @Override
    @Deprecated
    public List getChartOfAccountsForTds() {
        Query qry = this.getCurrentSession().createQuery("from CChartOfAccounts coa where purposeId = 10 order by glcode");
        return qry.list();
    }

    @Override
    @Deprecated
    public int getDetailTypeId(String glCode, Connection connection) throws Exception {
        int detailTypeId = 0;
        String qryDetailType = "Select detailtypeid from chartofaccountdetail where glcodeid=(select id from chartofaccounts where glcode=?)";
        PreparedStatement st = connection.prepareStatement(qryDetailType);
        st.setString(1, glCode);
        ResultSet rs = st.executeQuery();
        if (rs.next()) {
            detailTypeId = rs.getInt(1);
        }
        rs.close();
        st.close();
        return detailTypeId;
    }

    @Override
    @Deprecated
    public int getDetailTypeIdByName(String glCode, Connection connection, String name) {
        SQLQuery query = this.persistenceService.getSession().createSQLQuery("SELECT a.ID FROM accountdetailtype a,chartofaccountdetail coad  WHERE coad.DETAILTYPEID =a.ID  AND coad.glcodeid=(SELECT ID FROM chartofaccounts WHERE glcode=:glCode) AND a.NAME=:name");
        query.setString("glCode", glCode);
        query.setString("name", name);
        List accountDtlTypeList = query.list();
        return accountDtlTypeList != null && accountDtlTypeList.size() != 0 ? Integer.valueOf(accountDtlTypeList.get(0).toString()) : 0;
    }

    @Override
    public Accountdetailtype getAccountDetailTypeIdByName(String glCode, String name) {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)glCode)) {
            throw new ApplicationRuntimeException("Account Code or Account Detail Type Name is empty");
        }
        Query query = this.getCurrentSession().createQuery("from CChartOfAccounts where glcode=:glCode");
        query.setString("glCode", glCode);
        if (query.list().isEmpty()) {
            throw new ApplicationRuntimeException("GL Code not found in Chart of Accounts");
        }
        query = this.getCurrentSession().createQuery("from Accountdetailtype where id in (select cd.detailTypeId from CChartOfAccountDetail  as cd,CChartOfAccounts as c where cd.glCodeId=c.id and c.glcode=:glCode) and name=:name");
        query.setString("glCode", glCode);
        query.setString("name", name);
        return (Accountdetailtype)((Object)query.uniqueResult());
    }

    @Override
    public List getGlcode(String minGlcode, String maxGlcode, String majGlcode) {
        Query qry = null;
        StringBuilder qryStr = new StringBuilder("select coa.glcode from CChartOfAccounts coa where ");
        if (StringUtils.isNotBlank((CharSequence)minGlcode) && StringUtils.isNotBlank((CharSequence)maxGlcode)) {
            qryStr.append(" coa.glcode between :minGlcode and :maxGlcode ");
            qry = this.getCurrentSession().createQuery(qryStr.toString());
            qry.setString("minGlcode", minGlcode + "%");
            qry.setString("maxGlcode", maxGlcode + "%");
        } else if (StringUtils.isNotBlank((CharSequence)maxGlcode)) {
            qryStr.append(" coa.glcode like :maxGlcode ");
            qry = this.getCurrentSession().createQuery(qryStr.toString());
            qry.setString("maxGlcode", maxGlcode + "%");
        } else if (StringUtils.isNotBlank((CharSequence)majGlcode)) {
            qryStr.append(" coa.glcode =:majGlcode ");
            qry = this.getCurrentSession().createQuery(qryStr.toString());
            qry.setString("majGlcode", majGlcode);
        }
        return qry == null ? null : qry.list();
    }

    @Override
    public List<CChartOfAccounts> getActiveAccountsForType(char type) {
        Query query = this.getCurrentSession().createQuery("select acc from CChartOfAccounts acc where acc.classification='4' and acc.isActiveForPosting=true and type=:type order by acc.name");
        query.setCharacter("type", type);
        return query.list();
    }

    @Override
    public List<CChartOfAccounts> getAccountCodeByPurpose(Integer purposeId) {
        ArrayList<CChartOfAccounts> accountCodeList = new ArrayList<CChartOfAccounts>();
        try {
            if (purposeId == null || purposeId == 0) {
                throw new ApplicationException("Purpose Id is null or zero");
            }
            Query query = this.getCurrentSession().createQuery(" from EgfAccountcodePurpose purpose where purpose.id=" + purposeId + "");
            if (query.list().size() == 0) {
                throw new ApplicationException("Purpose ID provided is not defined in the system");
            }
            query = this.persistenceService.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE purposeid=:purposeId))) AND classification=4 AND isActiveForPosting=true ");
            query.setLong("purposeId", (long)purposeId.intValue());
            accountCodeList.addAll(query.list());
            query = this.persistenceService.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE purposeid=:purposeId)) AND classification=4 AND isActiveForPosting=true ");
            query.setLong("purposeId", (long)purposeId.intValue());
            accountCodeList.addAll(query.list());
            query = this.persistenceService.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE purposeid=:purposeId) AND classification=4 AND isActiveForPosting=true ");
            query.setLong("purposeId", (long)purposeId.intValue());
            accountCodeList.addAll(query.list());
            query = this.getCurrentSession().createQuery(" FROM CChartOfAccounts WHERE purposeid=:purposeId AND classification=4 AND isActiveForPosting=true ");
            query.setLong("purposeId", (long)purposeId.intValue());
            accountCodeList.addAll(query.list());
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new ApplicationRuntimeException("Error occurred while getting Account Code by purpose", (Throwable)e);
        }
        return accountCodeList;
    }

    @Override
    public List<CChartOfAccounts> getNonControlCodeList() {
        try {
            return this.getCurrentSession().createQuery(" from CChartOfAccounts acc where acc.classification=4 and acc.isActiveForPosting=true and acc.id not in (select cd.glCodeId from CChartOfAccountDetail cd) ").list();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new ApplicationRuntimeException("Error occurred while getting Non-Control Code list", (Throwable)e);
        }
    }

    @Override
    public List<Accountdetailtype> getAccountdetailtypeListByGLCode(String glCode) {
        if (StringUtils.isBlank((CharSequence)glCode)) {
            throw new ApplicationRuntimeException("GL Code is empty ");
        }
        CChartOfAccounts cChartOfAccountsByGlCode = this.getCChartOfAccountsByGlCode(glCode);
        if (cChartOfAccountsByGlCode == null) {
            throw new ApplicationRuntimeException("GL Code not found in Chart of Accounts");
        }
        try {
            Query query = this.persistenceService.getSession().createQuery("from Accountdetailtype where id in (select cd.detailTypeId from CChartOfAccountDetail  as cd,CChartOfAccounts as c where cd.glCodeId=c.id and c.glcode=:glCode)");
            query.setString("glCode", glCode);
            query.setCacheable(true);
            return query.list().isEmpty() ? null : query.list();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new ApplicationRuntimeException("Error occured while getting Account Detail Types for GL Code ", (Throwable)e);
        }
    }

    @Override
    public List<CChartOfAccounts> getActiveAccountsForTypes(char[] type) throws ValidationException {
        if (null == type || type.length == 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("type", "The supplied value for Chart of Account Type  can not be null or empty")));
        }
        Object[] types = new Character[type.length];
        int count = 0;
        for (char typ : type) {
            types[count++] = Character.valueOf(typ);
        }
        Query query = this.getCurrentSession().createQuery("from CChartOfAccounts where classification=4 and isActiveForPosting=true and type in (:type)");
        query.setParameterList("type", types);
        query.setCacheable(true);
        return query.list();
    }

    @Override
    public List<CChartOfAccounts> getAccountCodeByListOfPurposeId(Integer[] purposeId) throws ValidationException {
        if (null == purposeId || purposeId.length == 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("purposeId", "The supplied purposeId  can not be null or empty")));
        }
        ArrayList<CChartOfAccounts> listChartOfAcc = new ArrayList<CChartOfAccounts>();
        Query query = this.getCurrentSession().createQuery(" FROM CChartOfAccounts WHERE purposeid in(:purposeId)AND classification=4 AND isActiveForPosting=true ");
        query.setParameterList("purposeId", (Object[])purposeId);
        query.setCacheable(true);
        listChartOfAcc.addAll(query.list());
        query = this.persistenceService.getSession().createQuery(" from CChartOfAccounts where parentId IN (select id  FROM CChartOfAccounts WHERE purposeid in (:purposeId) ) AND classification=4 AND isActiveForPosting=true ");
        query.setParameterList("purposeId", (Object[])purposeId);
        query.setCacheable(true);
        listChartOfAcc.addAll(query.list());
        query = this.persistenceService.getSession().createQuery(" from CChartOfAccounts where   parentId IN (select id from CChartOfAccounts where parentId IN (select id  FROM CChartOfAccounts WHERE purposeid in (:purposeId))) AND classification=4 AND isActiveForPosting=true");
        query.setParameterList("purposeId", (Object[])purposeId);
        query.setCacheable(true);
        listChartOfAcc.addAll(query.list());
        query = this.persistenceService.getSession().createQuery(" from CChartOfAccounts where   parentId IN (select id from  CChartOfAccounts where   parentId IN (select id from CChartOfAccounts where parentId IN (select id  FROM CChartOfAccounts WHERE purposeid in (:purposeId)))) AND classification=4 AND isActiveForPosting=true ");
        query.setParameterList("purposeId", (Object[])purposeId);
        query.setCacheable(true);
        listChartOfAcc.addAll(query.list());
        return listChartOfAcc;
    }

    @Override
    public List<CChartOfAccounts> getListOfDetailCode(String glCode) throws ValidationException {
        if (StringUtils.isBlank((CharSequence)glCode)) {
            throw new ValidationException(Arrays.asList(new ValidationError("glcode null", "the glcode value supplied can not be null or blank")));
        }
        Query query = this.getCurrentSession().createQuery("from CChartOfAccounts where glcode=:glCode");
        query.setString("glCode", glCode);
        query.setCacheable(true);
        if (query.list().isEmpty()) {
            throw new ValidationException(Arrays.asList(new ValidationError("glcode not exist", "The GL Code value supplied does not exist in the System")));
        }
        ArrayList<CChartOfAccounts> listChartOfAcc = new ArrayList<CChartOfAccounts>();
        query = this.getCurrentSession().createQuery(" FROM CChartOfAccounts WHERE glcode=:glCode  AND classification=4 AND isActiveForPosting=true ");
        query.setString("glCode", glCode);
        query.setCacheable(true);
        listChartOfAcc.addAll(query.list());
        query = this.getCurrentSession().createQuery(" from CChartOfAccounts where parentId IN (select id  FROM CChartOfAccounts WHERE glcode=:glCode) AND classification=4 AND isActiveForPosting=true ");
        query.setString("glCode", glCode);
        query.setCacheable(true);
        listChartOfAcc.addAll(query.list());
        query = this.getCurrentSession().createQuery(" from CChartOfAccounts where parentId IN (select id from CChartOfAccounts where parentId IN ( select id  FROM CChartOfAccounts WHERE glcode=:glCode)) AND classification=4 AND isActiveForPosting=true ");
        query.setString("glCode", glCode);
        query.setCacheable(true);
        listChartOfAcc.addAll(query.list());
        query = this.getCurrentSession().createQuery(" from CChartOfAccounts where parentId IN (select id from  CChartOfAccounts where   parentId IN (select id from CChartOfAccounts where parentId IN ( select id  FROM CChartOfAccounts WHERE glcode=:glCode)))AND classification=4 AND isActiveForPosting=true ");
        query.setString("glCode", glCode);
        query.setCacheable(true);
        listChartOfAcc.addAll(query.list());
        return listChartOfAcc;
    }

    @Override
    public List<CChartOfAccounts> getBankChartofAccountCodeList() {
        return this.getCurrentSession().createQuery("select chartofaccounts from Bankaccount").setCacheable(true).list();
    }

    @Override
    public List<CChartOfAccounts> findByType(Character type) {
        Query query = this.getCurrentSession().createQuery("from CChartOfAccounts where  type =:type and classification=1");
        query.setCharacter("type", type.charValue());
        return query.list();
    }

    @Override
    public List<CChartOfAccounts> findByMajorCodeAndClassification(String majorCode, Long classification) {
        Query query = this.getCurrentSession().createQuery("from CChartOfAccounts where  majorcode =:majorcode and classification=2");
        query.setString("majorcode", majorCode);
        return query.list();
    }

    @Override
    public List<CChartOfAccounts> findByGlcodeLikeIgnoreCaseAndClassificationAndMajorCode(String string, Long classification, String majorCode) {
        return null;
    }

    @Override
    public List<CChartOfAccounts> findByGlcodeLikeIgnoreCaseAndClassification(String string, Long classification) {
        return null;
    }

    @Override
    public List<CChartOfAccounts> getBySubLedgerCode(String subLedgerCode) {
        Query query = this.persistenceService.getSession().createQuery("from CChartOfAccounts where id in (select glCodeId.id from CChartOfAccountDetail where lower(detailTypeId.name) =:subLedgerCode  ) and type = 'L' and classification=4 and isActiveForPosting = true and id not in (select chartofaccounts.id from Recovery)");
        query.setString("subLedgerCode", subLedgerCode.toLowerCase());
        return query.list();
    }

    @Override
    public List<CChartOfAccounts> getForRecovery() {
        Query query = this.persistenceService.getSession().createQuery("from CChartOfAccounts where id in  (select chartofaccounts.id from Recovery)");
        return query.list();
    }

    @Override
    public List<CChartOfAccounts> getAccountCodeByPurposeName(String purposeName) {
        ArrayList<CChartOfAccounts> accountCodeList = new ArrayList<CChartOfAccounts>();
        try {
            if (purposeName == null || purposeName.equalsIgnoreCase("")) {
                throw new ApplicationException("Purpose Name is null or empty");
            }
            Query query = this.getCurrentSession().createQuery(" from EgfAccountcodePurpose purpose where purpose.name='" + purposeName + "'");
            if (query.list().size() == 0) {
                throw new ApplicationException("Purpose ID provided is not defined in the system");
            }
            query = this.persistenceService.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT coa.id FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId=purpose.id and purpose.name = :purposeName))) AND classification=4 AND isActiveForPosting=true ");
            query.setString("purposeName", purposeName);
            accountCodeList.addAll(query.list());
            query = this.persistenceService.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT id FROM CChartOfAccounts WHERE parentId IN (SELECT coa.id FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId=purpose.id and purpose.name = :purposeName)) AND classification=4 AND isActiveForPosting=true ");
            query.setString("purposeName", purposeName);
            accountCodeList.addAll(query.list());
            query = this.persistenceService.getSession().createQuery(" FROM CChartOfAccounts WHERE parentId IN (SELECT coa.id FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId=purpose.id and purpose.name = :purposeName) AND classification=4 AND isActiveForPosting=true ");
            query.setString("purposeName", purposeName);
            accountCodeList.addAll(query.list());
            query = this.getCurrentSession().createQuery("SELECT coa FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId=purpose.id and purpose.name = :purposeName AND coa.classification=4 AND coa.isActiveForPosting=true ");
            query.setString("purposeName", purposeName);
            accountCodeList.addAll(query.list());
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new ApplicationRuntimeException("Error occurred while getting Account Code by purpose", (Throwable)e);
        }
        return accountCodeList;
    }

    @Override
    public List<CChartOfAccounts> getAccountCodeByListOfPurposeName(String[] purposeNames) throws ValidationException {
        if (null == purposeNames || purposeNames.length == 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("purposeId", "The supplied purposeId  can not be null or empty")));
        }
        ArrayList<CChartOfAccounts> listChartOfAcc = new ArrayList<CChartOfAccounts>();
        Query query = this.getCurrentSession().createQuery("SELECT coa  FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId = purpose.id and purpose.name in(:purposeNames)AND coa.classification=4 AND coa.isActiveForPosting=true ");
        query.setParameterList("purposeNames", (Object[])purposeNames);
        query.setCacheable(true);
        listChartOfAcc.addAll(query.list());
        query = this.persistenceService.getSession().createQuery(" from CChartOfAccounts where parentId IN (select coa.id  FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId = purpose.id and purpose.name in (:purposeNames) ) AND classification=4 AND isActiveForPosting=true ");
        query.setParameterList("purposeNames", (Object[])purposeNames);
        query.setCacheable(true);
        listChartOfAcc.addAll(query.list());
        query = this.persistenceService.getSession().createQuery(" from CChartOfAccounts where   parentId IN (select id from CChartOfAccounts where parentId IN (select coa.id  FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId = purpose.id and purpose.name in (:purposeNames) )) AND classification=4 AND isActiveForPosting=true");
        query.setParameterList("purposeNames", (Object[])purposeNames);
        query.setCacheable(true);
        listChartOfAcc.addAll(query.list());
        query = this.persistenceService.getSession().createQuery(" from CChartOfAccounts where   parentId IN (select id from  CChartOfAccounts where   parentId IN (select id from CChartOfAccounts where parentId IN (select coa.id  FROM CChartOfAccounts coa,EgfAccountcodePurpose purpose WHERE coa.purposeId = purpose.id and purpose.name in (:purposeNames) ))) AND classification=4 AND isActiveForPosting=true ");
        query.setParameterList("purposeNames", (Object[])purposeNames);
        query.setCacheable(true);
        listChartOfAcc.addAll(query.list());
        return listChartOfAcc;
    }

    @Override
    public List<CChartOfAccounts> getAccountCodesListForBankEntries() {
        return this.getCurrentSession().createQuery("select acc from CChartOfAccounts acc where acc.isActiveForPosting=true and (acc.glcode like '1%' or acc.glcode like '2%') and acc.id not in (select cd.glCodeId from CChartOfAccountDetail cd) order by acc.glcode").setCacheable(true).list();
    }
}

