/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.commons.Bankbranch;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.ChequeFormat;
import org.egov.commons.EgSurrenderedCheques;
import org.egov.commons.Fund;
import org.egov.commons.utils.BankAccountType;
import org.egov.infra.persistence.entity.AbstractAuditable;

@Entity
@Table(name="BANKACCOUNT")
@SequenceGenerator(name="SEQ_BANKACCOUNT", sequenceName="SEQ_BANKACCOUNT", allocationSize=1)
public class Bankaccount
extends AbstractAuditable
implements Serializable {
    public static final String SEQ_BANKACCOUNT = "SEQ_BANKACCOUNT";
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SEQ_BANKACCOUNT", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @JoinColumn(name="branchid", nullable=true)
    private Bankbranch bankbranch;
    @ManyToOne
    @JoinColumn(name="glcodeid")
    private CChartOfAccounts chartofaccounts;
    @ManyToOne
    @JoinColumn(name="fundid")
    private Fund fund;
    @NotNull
    private String accountnumber;
    private String accounttype;
    private String narration;
    @NotNull
    private Boolean isactive;
    private String payTo;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type")
    private BankAccountType type;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="bankaccount")
    private Set<EgSurrenderedCheques> egSurrenderedChequeses = new HashSet<EgSurrenderedCheques>(0);
    @ManyToOne
    @JoinColumn(name="chequeformatid")
    private ChequeFormat chequeformat;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Bankbranch getBankbranch() {
        return this.bankbranch;
    }

    public void setBankbranch(Bankbranch bankbranch) {
        this.bankbranch = bankbranch;
    }

    public CChartOfAccounts getChartofaccounts() {
        return this.chartofaccounts;
    }

    public void setChartofaccounts(CChartOfAccounts chartofaccounts) {
        this.chartofaccounts = chartofaccounts;
    }

    public Fund getFund() {
        return this.fund;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public String getAccountnumber() {
        return this.accountnumber;
    }

    public void setAccountnumber(String accountnumber) {
        this.accountnumber = accountnumber;
    }

    public String getAccounttype() {
        return this.accounttype;
    }

    public void setAccounttype(String accounttype) {
        this.accounttype = accounttype;
    }

    public String getNarration() {
        return this.narration;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public BankAccountType getType() {
        return this.type;
    }

    public void setType(BankAccountType type) {
        this.type = type;
    }

    public Set<EgSurrenderedCheques> getEgSurrenderedChequeses() {
        return this.egSurrenderedChequeses;
    }

    public void setEgSurrenderedChequeses(Set<EgSurrenderedCheques> egSurrenderedChequeses) {
        this.egSurrenderedChequeses = egSurrenderedChequeses;
    }

    public String getPayTo() {
        return this.payTo;
    }

    public void setPayTo(String payTo) {
        this.payTo = payTo;
    }

    public Boolean getIsactive() {
        return this.isactive;
    }

    public void setIsactive(Boolean isactive) {
        this.isactive = isactive;
    }

    public ChequeFormat getChequeformat() {
        return this.chequeformat;
    }

    public void setChequeformat(ChequeFormat chequeformat) {
        this.chequeformat = chequeformat;
    }
}

