/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FinancialYearHibernateDAO
implements FinancialYearDAO {
    @PersistenceContext
    private EntityManager entityManager;
    private final Logger logger = Logger.getLogger((String)this.getClass().getName());

    @Override
    @Transactional
    public CFinancialYear update(CFinancialYear entity) {
        this.getCurrentSession().update((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public CFinancialYear create(CFinancialYear entity) {
        this.getCurrentSession().persist((Object)entity);
        return entity;
    }

    @Override
    @Transactional
    public void delete(CFinancialYear entity) {
        this.getCurrentSession().delete((Object)entity);
    }

    @Override
    public CFinancialYear findById(Number id, boolean lock) {
        return (CFinancialYear)((Object)this.getCurrentSession().load(CFinancialYear.class, (Serializable)id));
    }

    @Override
    public List<CFinancialYear> findAll() {
        return this.getCurrentSession().createCriteria(CFinancialYear.class).list();
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public String getCurrYearFiscalId() {
        Date dt = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
        String currentDate = formatter.format(dt);
        String result = "";
        Query query = this.getCurrentSession().createQuery("select cfinancialyear.id from CFinancialYear cfinancialyear where cfinancialyear.startingDate <= '" + currentDate + "' and cfinancialyear.endingDate >= '" + currentDate + "' ");
        ArrayList list = (ArrayList)query.list();
        result = list.get(0).toString();
        return result;
    }

    @Override
    public String getCurrYearStartDate() {
        Date dt = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
        String currentDate = formatter.format(dt);
        this.logger.info((Object)"Obtained session");
        String result = "";
        Query query = this.getCurrentSession().createQuery("select cfinancialyear.startingDate from CFinancialYear cfinancialyear where cfinancialyear.startingDate <= '" + currentDate + "' and cfinancialyear.endingDate >= '" + currentDate + "' ");
        ArrayList list = (ArrayList)query.list();
        if (list.size() > 0) {
            if (list.get(0) == null) {
                return "0.0";
            }
        } else {
            return "0.0";
        }
        result = list.get(0).toString();
        return result;
    }

    @Override
    public String getPrevYearFiscalId() {
        Date dt = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(dt);
        int prevYear = calendar.get(1) - 1;
        calendar.set(1, prevYear);
        String previousDate = formatter.format(calendar.getTime());
        this.logger.info((Object)"Obtained session");
        String result = "";
        Query query = this.getCurrentSession().createQuery("select cfinancialyear.id from CFinancialYear cfinancialyear where cfinancialyear.startingDate <= '" + previousDate + "' and cfinancialyear.endingDate >= '" + previousDate + "' ");
        ArrayList list = (ArrayList)query.list();
        if (list.size() > 0) {
            if (list.get(0) == null) {
                return "0.0";
            }
        } else {
            return "0.0";
        }
        result = list.get(0).toString();
        return result;
    }

    @Override
    @Deprecated
    public String getFinancialYearId(String estDate) {
        this.logger.info((Object)"Obtained session");
        String result = "";
        Query query = this.getCurrentSession().createQuery("select cfinancialyear.id from CFinancialYear cfinancialyear where cfinancialyear.startingDate <= to_date('" + estDate + "','dd/MM/yyyy') and cfinancialyear.endingDate >= to_date('" + estDate + "','dd/MM/yyyy') ");
        ArrayList list = (ArrayList)query.list();
        if (list.size() > 0) {
            result = list.get(0).toString();
        }
        return result;
    }

    @Override
    public CFinancialYear getFinancialYearByFinYearRange(String finYearRange) {
        Query query = this.getCurrentSession().createQuery("from CFinancialYear cfinancialyear where cfinancialyear.finYearRange=:finYearRange");
        query.setString("finYearRange", finYearRange);
        query.setCacheable(true);
        return (CFinancialYear)((Object)query.uniqueResult());
    }

    @Override
    public List<CFinancialYear> getAllActiveFinancialYearList() {
        Query query = this.getCurrentSession().createQuery("from CFinancialYear cfinancialyear where isActive=true order by finYearRange desc");
        return query.list();
    }

    @Override
    public List<CFinancialYear> getAllActivePostingFinancialYear() {
        Query query = this.getCurrentSession().createQuery("from CFinancialYear cfinancialyear where isActive=true and isActiveForPosting=true order by startingDate desc");
        return query.list();
    }

    @Override
    public List<CFinancialYear> getAllNotClosedFinancialYears() {
        Query query = this.getCurrentSession().createQuery("from CFinancialYear cfinancialyear where cfinancialyear.isClosed=false  order by cfinancialyear.startingDate asc");
        return query.list();
    }

    @Override
    public CFinancialYear getFinancialYearById(Long id) {
        Query query = this.getCurrentSession().createQuery("from CFinancialYear cfinancialyear where id=:id");
        query.setLong("id", id.longValue());
        return (CFinancialYear)((Object)query.uniqueResult());
    }

    @Override
    public List<CFinancialYear> getAllActivePostingAndNotClosedFinancialYears() {
        Query query = this.getCurrentSession().createQuery("from CFinancialYear cfinancialyear where cfinancialyear.isClosed=false  and cfinancialyear.isActiveForPosting=true  order by cfinancialyear.startingDate asc");
        return query.list();
    }

    @Override
    public boolean isFinancialYearActiveForPosting(Date fromDate, Date toDate) {
        this.logger.info((Object)"Obtained session");
        String result = "";
        Query query = this.getCurrentSession().createQuery(" from CFinancialYear cfinancialyear where   cfinancialyear.isActiveForPosting=false and cfinancialyear.startingDate <=:sDate and cfinancialyear.endingDate >=:eDate  ");
        query.setDate("sDate", fromDate);
        query.setDate("eDate", toDate);
        ArrayList list = (ArrayList)query.list();
        return list.size() <= 0;
    }

    @Override
    public CFinancialYear getFinancialYearByDate(Date date) {
        CFinancialYear cFinancialYear = null;
        this.logger.info((Object)"Obtained session");
        String result = "";
        Query query = this.getCurrentSession().createQuery(" from CFinancialYear cfinancialyear where cfinancialyear.startingDate <=:sDate and cfinancialyear.endingDate >=:eDate  and cfinancialyear.isActiveForPosting=true");
        query.setDate("sDate", date);
        query.setDate("eDate", date);
        ArrayList list = (ArrayList)query.list();
        if (list.size() > 0) {
            cFinancialYear = (CFinancialYear)((Object)list.get(0));
        }
        if (null == cFinancialYear) {
            throw new ApplicationRuntimeException("Financial Year is not active For Posting.");
        }
        return cFinancialYear;
    }

    @Override
    public CFinancialYear getFinYearByDate(Date date) {
        CFinancialYear cFinancialYear = null;
        this.logger.info((Object)"Obtained session");
        Query query = this.getCurrentSession().createQuery(" from CFinancialYear cfinancialyear where cfinancialyear.startingDate <=:sDate and cfinancialyear.endingDate >=:eDate");
        query.setDate("sDate", date);
        query.setDate("eDate", date);
        ArrayList list = (ArrayList)query.list();
        if (list.size() > 0) {
            cFinancialYear = (CFinancialYear)((Object)list.get(0));
        }
        if (null == cFinancialYear) {
            throw new ApplicationRuntimeException("Financial Year Id does not exist.");
        }
        return cFinancialYear;
    }

    public CFinancialYear getTwoPreviousYearByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -2);
        return this.getFinYearByDate(cal.getTime());
    }

    @Override
    public CFinancialYear getNextFinancialYearByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, 1);
        return this.getFinYearByDate(cal.getTime());
    }

    @Override
    public CFinancialYear getPreviousFinancialYearByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, -1);
        return this.getFinYearByDate(cal.getTime());
    }

    @Override
    public boolean isSameFinancialYear(Date fromDate, Date toDate) {
        return this.getFinYearByDate(fromDate).getId().longValue() == this.getFinYearByDate(toDate).getId().longValue();
    }

    @Override
    public List<CFinancialYear> getAllPriorFinancialYears(Date date) {
        Query query = this.getCurrentSession().createQuery(" from CFinancialYear cfinancialyear where cfinancialyear.startingDate <:sDate and isActive=true order by finYearRange desc ");
        query.setDate("sDate", date);
        return query.list();
    }
}

