/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.commons.Bank;
import org.egov.commons.Bankaccount;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="BANKBRANCH")
@SequenceGenerator(name="SEQ_BANKBRANCH", sequenceName="SEQ_BANKBRANCH", allocationSize=1)
@Unique(fields={"branchMICR"}, enableDfltMsg=true)
public class Bankbranch
extends AbstractPersistable<Integer> {
    private static final long serialVersionUID = -1445070413847273114L;
    public static final String SEQ_BANKBRANCH = "SEQ_BANKBRANCH";
    @Id
    @GeneratedValue(generator="SEQ_BANKBRANCH", strategy=GenerationType.SEQUENCE)
    private Integer id;
    @ManyToOne
    @JoinColumn(name="bankid")
    private Bank bank;
    @Required
    @Length(max=50)
    private String branchcode;
    @Required
    @Length(max=50)
    private String branchname;
    @Required
    @Length(max=50)
    private String branchaddress1;
    @Length(max=50)
    private String branchaddress2;
    @Length(max=50)
    private String branchcity;
    @Length(max=50)
    private String branchstate;
    @Length(max=50)
    private String branchpin;
    @Length(max=15)
    private String branchphone;
    @Length(max=15)
    private String branchfax;
    @Length(max=50)
    private String contactperson;
    @Required
    private Boolean isactive;
    @Length(max=250)
    private String narration;
    @Length(max=50)
    @Column(name="micr")
    private String branchMICR;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="bankbranch", targetEntity=Bankaccount.class)
    @JsonIgnore
    private Set<Bankaccount> bankaccounts = new HashSet<Bankaccount>(0);
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="createdby")
    private User createdBy;
    @JsonIgnore
    private Date createdDate;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="lastModifiedBy")
    private User lastModifiedBy;
    @JsonIgnore
    private Date lastModifiedDate;

    public boolean isAccountsExist() {
        return this.bankaccounts != null && !this.bankaccounts.isEmpty();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public String getBranchcode() {
        return this.branchcode;
    }

    public void setBranchcode(String branchcode) {
        this.branchcode = branchcode;
    }

    public String getBranchname() {
        return this.branchname;
    }

    public void setBranchname(String branchname) {
        this.branchname = branchname;
    }

    public String getBranchaddress1() {
        return this.branchaddress1;
    }

    public void setBranchaddress1(String branchaddress1) {
        this.branchaddress1 = branchaddress1;
    }

    public String getBranchaddress2() {
        return this.branchaddress2;
    }

    public void setBranchaddress2(String branchaddress2) {
        this.branchaddress2 = branchaddress2;
    }

    public String getBranchcity() {
        return this.branchcity;
    }

    public void setBranchcity(String branchcity) {
        this.branchcity = branchcity;
    }

    public String getBranchstate() {
        return this.branchstate;
    }

    public void setBranchstate(String branchstate) {
        this.branchstate = branchstate;
    }

    public String getBranchpin() {
        return this.branchpin;
    }

    public void setBranchpin(String branchpin) {
        this.branchpin = branchpin;
    }

    public String getBranchphone() {
        return this.branchphone;
    }

    public void setBranchphone(String branchphone) {
        this.branchphone = branchphone;
    }

    public String getBranchfax() {
        return this.branchfax;
    }

    public void setBranchfax(String branchfax) {
        this.branchfax = branchfax;
    }

    public String getContactperson() {
        return this.contactperson;
    }

    public void setContactperson(String contactperson) {
        this.contactperson = contactperson;
    }

    public String getNarration() {
        return this.narration;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public String getBranchMICR() {
        return this.branchMICR;
    }

    public void setBranchMICR(String branchMICR) {
        this.branchMICR = branchMICR;
    }

    public Set<Bankaccount> getBankaccounts() {
        return this.bankaccounts;
    }

    public void setBankaccounts(Set<Bankaccount> bankaccounts) {
        this.bankaccounts = bankaccounts;
    }

    public Boolean getIsactive() {
        return this.isactive;
    }

    public void setIsactive(Boolean isactive) {
        this.isactive = isactive;
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public User getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(User lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }
}

