/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.dao;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.common.entity.UOM;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class UOMDao {
    @PersistenceContext
    private EntityManager entityManager;

    public List<UOM> findAllUom() {
        Query qry = ((Session)this.entityManager.unwrap(Session.class)).createQuery("from EgUom uom order by uomcategoryid");
        return qry.list();
    }

    public List<UOM> getAllUomsWithinCategoryByUom(Integer uomId) throws ValidationException {
        ArrayList<UOM> uoms = new ArrayList();
        Query qry = null;
        if (uomId == null || uomId < 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("uom null", "UomId is null")));
        }
        qry = ((Session)this.entityManager.unwrap(Session.class)).createQuery("from org.egov.common.entity.UOM as uoms where uoms.uomCategory.id =(select uom.uomCategory.id  from org.egov.common.entity.UOM uom where uom.id=:uomID)");
        qry.setInteger("uomID", uomId.intValue());
        uoms = qry.list();
        return uoms;
    }

    public BigDecimal getConversionFactorByUom(Integer uomId) throws ValidationException {
        BigDecimal convFactor = BigDecimal.ZERO;
        Query qry = null;
        if (uomId == null || uomId <= 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("uom null", "UomId is null")));
        }
        qry = ((Session)this.entityManager.unwrap(Session.class)).createQuery("select uom.convFactor from org.egov.infstr.commonMasters.EgUom as uom where uom.id=:uomID");
        qry.setInteger("uomID", uomId.intValue());
        convFactor = (BigDecimal)qry.uniqueResult();
        return convFactor;
    }

    public BigDecimal getConversionFactorByFromUomToUom(Integer fromuomId, Integer touomId) throws ValidationException {
        BigDecimal convFactor = null;
        if (fromuomId == null || fromuomId <= 0 || touomId == null || touomId <= 0) {
            throw new ValidationException(Arrays.asList(new ValidationError("uom null", "from or to uomId  is null")));
        }
        BigDecimal fromconvFactor = this.getConversionFactorByUom(fromuomId);
        BigDecimal toFactor = this.getConversionFactorByUom(touomId);
        convFactor = BigDecimal.valueOf(fromconvFactor.doubleValue() / toFactor.doubleValue());
        return convFactor;
    }
}

