/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.common.entity.UOMCategory;
import org.egov.commons.repository.UOMCategoryRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class UOMCategoryService {
    private final UOMCategoryRepository uomCategoryRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public UOMCategoryService(UOMCategoryRepository uomCategoryRepository) {
        this.uomCategoryRepository = uomCategoryRepository;
    }

    @Transactional
    public UOMCategory create(UOMCategory uomCategory) {
        return (UOMCategory)((Object)this.uomCategoryRepository.save((Object)uomCategory));
    }

    @Transactional
    public UOMCategory update(UOMCategory uomCategory) {
        return (UOMCategory)((Object)this.uomCategoryRepository.save((Object)uomCategory));
    }

    public List<UOMCategory> findAll() {
        return this.uomCategoryRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"category"}));
    }

    public UOMCategory findOne(Long id) {
        return (UOMCategory)((Object)this.uomCategoryRepository.findOne(id));
    }

    public List<UOMCategory> search(UOMCategory uomCategory) {
        if (uomCategory.getCategory() != null) {
            return this.uomCategoryRepository.findByCategory(uomCategory.getCategory());
        }
        return this.uomCategoryRepository.findAll();
    }
}

