/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Bank;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.hibernate.Session;

public class BankDAO {
    @PersistenceContext
    private EntityManager entityManager;

    private Session getSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public void createBank(Bank bank) {
        try {
            this.getSession().save((Object)bank);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while creating Bank", (Throwable)e);
        }
    }

    public void updateBank(Bank bank) {
        try {
            this.getSession().saveOrUpdate((Object)bank);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while updating Bank", (Throwable)e);
        }
    }

    public void removeBank(Bank bank) {
        try {
            this.getSession().delete((Object)bank);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while deleting Bank", (Throwable)e);
        }
    }

    public Bank getBankById(int bank) {
        try {
            return (Bank)((Object)this.getSession().get(Bank.class, (Serializable)Integer.valueOf(bank)));
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occurred while getting Bank by id", (Throwable)e);
        }
    }
}

