/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.commons.CFiscalPeriod;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Entity
@Table(name="financialyear")
@Unique(id="id", tableName="financialyear", fields={"finYearRange"}, columnName={"financialyear"}, enableDfltMsg=true)
@SequenceGenerator(name="SEQ_FINANCIALYEAR", sequenceName="SEQ_FINANCIALYEAR", allocationSize=1)
public class CFinancialYear
extends AbstractAuditable {
    private static final long serialVersionUID = -1563670460427134487L;
    public static final String SEQ_CFINANCIALYEAR = "SEQ_FINANCIALYEAR";
    @Id
    @GeneratedValue(generator="SEQ_FINANCIALYEAR", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Length(min=1, max=25)
    @NotBlank
    @Column(name="financialyear")
    private String finYearRange;
    @NotNull
    private Date startingDate;
    @NotNull
    private Date endingDate;
    private Boolean isActive;
    private Boolean isActiveForPosting;
    private Boolean isClosed;
    private Boolean transferClosingBalance;
    @OneToMany(mappedBy="cFinancialYear", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="id DESC ")
    @NotAudited
    private final List<CFiscalPeriod> cFiscalPeriod = new ArrayList<CFiscalPeriod>(0);

    public Boolean getIsActive() {
        return this.isActive;
    }

    public Boolean getIsClosed() {
        return this.isClosed;
    }

    public Boolean getTransferClosingBalance() {
        return this.transferClosingBalance;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public void setIsClosed(Boolean isClosed) {
        this.isClosed = isClosed;
    }

    public void setTransferClosingBalance(Boolean transferClosingBalance) {
        this.transferClosingBalance = transferClosingBalance;
    }

    public String getFinYearRange() {
        return this.finYearRange;
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public Date getEndingDate() {
        return this.endingDate;
    }

    public Boolean getIsActiveForPosting() {
        return this.isActiveForPosting;
    }

    public void setFinYearRange(String finYearRange) {
        this.finYearRange = finYearRange;
    }

    public void setStartingDate(Date startingDate) {
        this.startingDate = startingDate;
    }

    public void setEndingDate(Date endingDate) {
        this.endingDate = endingDate;
    }

    public void setIsActiveForPosting(Boolean isActiveForPosting) {
        this.isActiveForPosting = isActiveForPosting;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<CFiscalPeriod> getcFiscalPeriod() {
        return this.cFiscalPeriod;
    }

    public void setcFiscalPeriod(List<CFiscalPeriod> cFiscalPeriod) {
        this.cFiscalPeriod.clear();
        if (cFiscalPeriod != null) {
            this.cFiscalPeriod.addAll(cFiscalPeriod);
        }
    }

    public void addCFiscalPeriod(CFiscalPeriod cFiscalPeriod) {
        this.getcFiscalPeriod().add(cFiscalPeriod);
    }
}

