/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.TypeOfWorkSearchRequest;
import org.egov.commons.repository.TypeOfWorkRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TypeOfWorkService {
    private final TypeOfWorkRepository typeOfWorkRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public TypeOfWorkService(TypeOfWorkRepository typeOfWorkRepository) {
        this.typeOfWorkRepository = typeOfWorkRepository;
    }

    @Transactional
    public EgwTypeOfWork create(EgwTypeOfWork typeOfWork) {
        return (EgwTypeOfWork)((Object)this.typeOfWorkRepository.save((Object)typeOfWork));
    }

    public EgwTypeOfWork getTypeOfWorkById(Long typeOfWorkId) {
        return (EgwTypeOfWork)((Object)this.typeOfWorkRepository.findOne(typeOfWorkId));
    }

    public EgwTypeOfWork getTypeOfWorkByCode(String code) {
        return this.typeOfWorkRepository.findByCodeIgnoreCase(code);
    }

    public List<EgwTypeOfWork> findAll() {
        return this.typeOfWorkRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public List<EgwTypeOfWork> searchTypeOfWorkToView(TypeOfWorkSearchRequest searchRequestTypeOfWork) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(EgwTypeOfWork.class).addOrder(Order.asc((String)"createdDate"));
        if (searchRequestTypeOfWork != null) {
            if (searchRequestTypeOfWork.getTypeOfWorkCode() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"code", (Object)searchRequestTypeOfWork.getTypeOfWorkCode()));
            }
            if (searchRequestTypeOfWork.getTypeOfWorkName() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"name", (Object)searchRequestTypeOfWork.getTypeOfWorkName()));
            }
            criteria.add(Restrictions.isNull((String)"parentid.id"));
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<EgwTypeOfWork> getTypeOfWorkByPartyType(String partyTypeCode) {
        return this.typeOfWorkRepository.findByPartyType(partyTypeCode.toUpperCase());
    }

    public List<EgwTypeOfWork> getByParentidAndEgPartytype(Long parentId, String partyTypeCode) {
        return this.typeOfWorkRepository.findByParentidAndEgPartytype(parentId, partyTypeCode.toUpperCase());
    }

    public List<EgwTypeOfWork> searchSubTypeOfWorkToView(TypeOfWorkSearchRequest typeOfWorkSearchRequest) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(EgwTypeOfWork.class).addOrder(Order.asc((String)"createdDate"));
        if (typeOfWorkSearchRequest != null) {
            if (typeOfWorkSearchRequest.getTypeOfWorkParentId() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"parentid.id", (Object)typeOfWorkSearchRequest.getTypeOfWorkParentId()));
            }
            if (typeOfWorkSearchRequest.getTypeOfWorkCode() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"code", (Object)typeOfWorkSearchRequest.getTypeOfWorkCode()));
            }
            if (typeOfWorkSearchRequest.getTypeOfWorkName() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"name", (Object)typeOfWorkSearchRequest.getTypeOfWorkName()));
            }
            criteria.add(Restrictions.isNotNull((String)"parentid.id"));
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    @Transactional
    public EgwTypeOfWork update(EgwTypeOfWork typeOfWork) {
        return (EgwTypeOfWork)((Object)this.typeOfWorkRepository.save((Object)typeOfWork));
    }

    public List<EgwTypeOfWork> getActiveTypeOfWorksByPartyType(String partyTypeCode) {
        return this.typeOfWorkRepository.findByParentid_idIsNullAndEgPartytype_codeContainingIgnoreCaseAndActiveTrueOrderByName(partyTypeCode);
    }

    public List<EgwTypeOfWork> getActiveSubTypeOfWorksByParentIdAndPartyType(Long parentid, String partyTypeCode) {
        return this.typeOfWorkRepository.findByParentid_idAndEgPartytype_codeContainingIgnoreCaseAndActiveTrueOrderByName(parentid, partyTypeCode);
    }
}

