/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.utils.DateUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;

@Repository
public class InstallmentHibDao<T, id extends Serializable>
implements InstallmentDao {
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public List<Installment> getInsatllmentByModule(Module module) {
        Query qry = this.getCurrentSession().createQuery("from Installment I where I.module=:module order by installmentYear desc");
        qry.setEntity("module", (Object)module);
        return qry.list();
    }

    public List getInsatllmentByModule(Module module, Date year) {
        Query qry = this.getCurrentSession().createQuery("from Installment I where I.module=:module and I.installmentYear=:year");
        qry.setEntity("module", (Object)module);
        qry.setDate("year", year);
        return qry.list();
    }

    @Override
    public Installment getInsatllmentByModule(Module module, Date year, Integer installmentNumber) {
        Query qry = this.getCurrentSession().createQuery("from Installment I where I.module=:module and I.installmentYear=:year and I.installmentNumber =:instNum");
        qry.setEntity("module", (Object)module);
        qry.setDate("year", year);
        qry.setInteger("instNum", installmentNumber.intValue());
        return (Installment)qry.uniqueResult();
    }

    @Override
    public Installment getInsatllmentByModuleForGivenDate(Module module, Date installmentDate) {
        Query qry = this.getCurrentSession().createQuery("from Installment I where I.module=:module and (I.fromDate <= :fromYear and I.toDate >=:toYear)");
        qry.setEntity("module", (Object)module);
        qry.setDate("fromYear", installmentDate);
        qry.setDate("toYear", installmentDate);
        return (Installment)qry.uniqueResult();
    }

    @Override
    public List<Installment> getEffectiveInstallmentsforModuleandDate(Date dateToCompare, int noOfMonths, Module mod) {
        Query qry = this.getCurrentSession().createQuery("from org.egov.commons.Installment inst where  inst.toDate >= :dateToCompare and inst.toDate < :dateToComparemax   and inst.module=:module");
        qry.setDate("dateToCompare", dateToCompare);
        qry.setEntity("module", (Object)mod);
        Date dateToComparemax = DateUtils.add((Date)dateToCompare, (int)2, (int)noOfMonths);
        qry.setDate("dateToComparemax", dateToComparemax);
        return qry.list();
    }

    @Override
    public Installment getInsatllmentByModuleForGivenDateAndInstallmentType(Module module, Date installmentDate, String installmentType) {
        Query qry = this.getCurrentSession().createQuery("from Installment I where I.module=:module and (I.fromDate <= :fromYear and I.toDate >=:toYear) and I.installmentType = :installmentType");
        qry.setEntity("module", (Object)module);
        qry.setDate("fromYear", installmentDate);
        qry.setDate("toYear", installmentDate);
        qry.setString("installmentType", installmentType);
        return (Installment)qry.uniqueResult();
    }

    @Override
    public List<Installment> getInstallmentsByModuleForGivenDateAndInstallmentType(Module module, Date installmentDate, String installmentType) {
        Query qry = this.getCurrentSession().createQuery("from Installment I where I.module=:module and I.toDate >=:fromDate and I.toDate<=:tillDate and I.installmentType = :installmentType");
        qry.setEntity("module", (Object)module);
        qry.setDate("fromDate", installmentDate);
        qry.setDate("tillDate", new Date());
        qry.setString("installmentType", installmentType);
        return qry.list();
    }

    @Override
    public List<Installment> fetchInstallments(Module module, Date toInstallmentDate, int noOfInstallmentToFetch) {
        Query qry = this.getCurrentSession().createQuery("from Installment I where I.module=:module and I.installmentYear<=:installmentYear order by installmentYear desc");
        qry.setEntity("module", (Object)module);
        qry.setDate("installmentYear", toInstallmentDate);
        qry.setMaxResults(noOfInstallmentToFetch);
        return qry.list();
    }

    @Override
    public List<Installment> getAllInstallmentsByModuleAndStartDate(Module module, Date currDate) {
        Query qry = this.getCurrentSession().createQuery(" select inst  from Installment inst,CFinancialYear finYear where inst.module=:module and inst.fromDate >= (select fromDate from Installment  where module=:module and ((cast(:currDate as date)) between fromDate and toDate)) and cast(inst.toDate as date) <= cast(finYear.endingDate as date)   and now() between finYear.startingDate and finYear.endingDate order by inst.fromDate");
        qry.setLong("module", module.getId().longValue());
        qry.setDate("currDate", currDate);
        return qry.list();
    }

    @Override
    public Installment fetchInstallmentByModuleAndInstallmentNumber(Module module, Integer installmentNumber) {
        return (Installment)this.getCurrentSession().createQuery("from Installment I where I.module=:module and I.installmentNumber =:installmentNumber").setEntity("module", (Object)module).setInteger("installmentNumber", installmentNumber.intValue()).uniqueResult();
    }

    @Override
    public Installment getInsatllmentByModuleAndDescription(Module module, String description) {
        return (Installment)this.getCurrentSession().createQuery("from Installment I where I.module=:module and I.description =:description").setEntity("module", (Object)module).setString("description", description).uniqueResult();
    }

    public Installment findById(int i, boolean b) {
        return (Installment)this.getCurrentSession().get(Installment.class, (Serializable)Integer.valueOf(i));
    }

    @Override
    public List<Installment> fetchPreviousInstallmentsInDescendingOrderByModuleAndDate(Module module, Date installmentDate, int noOfInstallmentToFetch) {
        Query qry = this.getCurrentSession().createQuery("from Installment I where I.module=:module and I.toDate< :installmentDate order by fromDate desc");
        qry.setEntity("module", (Object)module);
        qry.setDate("installmentDate", installmentDate);
        qry.setMaxResults(noOfInstallmentToFetch);
        return qry.list();
    }
}

