/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.EgwTypeOfWork;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;

@Repository
public class EgwTypeOfWorkHibernateDAO {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List getAllTypeOfWork() {
        return this.getCurrentSession().createQuery("from EgwTypeOfWork typeOfWork order by upper(code)").list();
    }

    public List getAllTypeOfWorkOrderByDesc() {
        return this.getCurrentSession().createQuery("from EgwTypeOfWork typeOfWork order by upper(description)").list();
    }

    public EgwTypeOfWork getTypeOfWorkById(Long id) {
        Query qry = this.getCurrentSession().createQuery("from EgwTypeOfWork typeOfWork where typeOfWork.id =:id");
        qry.setLong("id", id.longValue());
        return (EgwTypeOfWork)((Object)qry.uniqueResult());
    }

    public List getSubTypeOfWorkByParentId(Long id) {
        Query query = this.getCurrentSession().createQuery("from EgwTypeOfWork typeOfWork where typeOfWork.parentid =:id and egPartytype.description='Contractor' order by upper(description)");
        query.setLong("id", id.longValue());
        return query.list();
    }

    public EgwTypeOfWork findByCode(String code) {
        Query qry = this.getCurrentSession().createQuery("from EgwTypeOfWork typeOfWork where upper(typeOfWork.code) =:code");
        qry.setString("code", code.toUpperCase().trim());
        return (EgwTypeOfWork)((Object)qry.uniqueResult());
    }

    public List<EgwTypeOfWork> getTypeOfWorkDetailFilterBy(String code, String parentCode, String description) {
        StringBuffer qryStr = new StringBuffer();
        qryStr.append("select distinct typeOfWork From EgwTypeOfWork typeOfWork where typeOfWork.createdby is not null ");
        if (code != null && !code.equals("")) {
            qryStr.append(" and (upper(typeOfWork.code) like :code)");
        }
        if (parentCode != null && !parentCode.equals("")) {
            qryStr.append(" and (upper(typeOfWork.parentid.code) like :parentCode)");
        }
        if (description != null && !description.equals("")) {
            qryStr.append(" and (upper(typeOfWork.description) like :description)");
        }
        Query qry = this.getCurrentSession().createQuery(qryStr.toString());
        if (code != null && !code.equals("")) {
            qry.setString("code", "%" + code.toUpperCase().trim() + "%");
        }
        if (parentCode != null && !parentCode.equals("")) {
            qry.setString("parentCode", "%" + parentCode.toUpperCase().trim() + "%");
        }
        if (description != null && !description.equals("")) {
            qry.setString("description", "%" + description.toUpperCase().trim() + "%");
        }
        return qry.list();
    }

    public List<EgwTypeOfWork> getTypeOfWorkDetailFilterByParty(String code, String parentCode, String description, String partyTypeCode) {
        StringBuffer qryStr = new StringBuffer();
        qryStr.append("select distinct typeOfWork From EgwTypeOfWork typeOfWork where typeOfWork.egPartytype is not null ");
        if (code != null && !code.equals("")) {
            qryStr.append(" and (upper(typeOfWork.code) like :code)");
        }
        if (parentCode != null && !parentCode.equals("")) {
            qryStr.append(" and (upper(typeOfWork.parentid.code) like :parentCode)");
        }
        if (description != null && !description.equals("")) {
            qryStr.append(" and (upper(typeOfWork.description) like :description)");
        }
        if (partyTypeCode != null && !partyTypeCode.equals("")) {
            qryStr.append(" and (upper(typeOfWork.egPartytype.code) like :partyTypeCode)");
        }
        Query qry = this.getCurrentSession().createQuery(qryStr.toString());
        if (code != null && !code.equals("")) {
            qry.setString("code", "%" + code.toUpperCase().trim() + "%");
        }
        if (parentCode != null && !parentCode.equals("")) {
            qry.setString("parentCode", "%" + parentCode.toUpperCase().trim() + "%");
        }
        if (description != null && !description.equals("")) {
            qry.setString("description", "%" + description.toUpperCase().trim() + "%");
        }
        if (partyTypeCode != null && !partyTypeCode.equals("")) {
            qry.setString("partyTypeCode", "%" + partyTypeCode.toUpperCase().trim() + "%");
        }
        return qry.list();
    }

    public List<EgwTypeOfWork> getAllParentOrderByCode() {
        return this.getCurrentSession().createQuery("from EgwTypeOfWork etw1 where etw1.parentid is null and etw1.id in (select etw2.parentid from EgwTypeOfWork etw2 where etw2.parentid = etw1.id) order by upper(code)").list();
    }

    public List<EgwTypeOfWork> getTypeOfWorkForPartyTypeContractor() {
        return this.getCurrentSession().createQuery("from EgwTypeOfWork etw1 where etw1.parentid is null and etw1.id in (select etw2.parentid from EgwTypeOfWork etw2 where etw2.parentid = etw1.id) and egPartytype.description='Contractor' order by upper(description)").list();
    }

    public List findAllParentPartyType() {
        return this.getCurrentSession().createQuery("from EgwTypeOfWork tw where tw.parentid is null and tw.egPartytype is not null order by upper(code)").list();
    }

    public List findAllChildPartyType() {
        return this.getCurrentSession().createQuery("from EgwTypeOfWork tw where tw.parentid is not null and tw.egPartytype is not null order by upper(code)").list();
    }
}

