/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="fund")
@SequenceGenerator(name="SEQ_Fund", sequenceName="SEQ_Fund", allocationSize=1)
@Unique(fields={"code", "name"}, enableDfltMsg=true)
public class Fund
extends AbstractPersistable<Integer> {
    public static final String SEQ = "SEQ_Fund";
    private static final long serialVersionUID = 7977534010758407945L;
    @Id
    @GeneratedValue(generator="SEQ_Fund", strategy=GenerationType.SEQUENCE)
    private Integer id;
    @Length(max=50, min=2)
    @Required
    private String name;
    @Length(max=50, min=2)
    @Required
    private String code;
    private Character identifier;
    @Required
    private BigDecimal llevel = BigDecimal.ONE;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parentid")
    private Fund parentId;
    private Boolean isnotleaf;
    private Boolean isactive;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="createdby")
    private User createdby;
    private Date createdDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="lastModifiedBy")
    private User lastModifiedBy;
    private Date lastModifiedDate;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Character getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Character identifier) {
        this.identifier = identifier;
    }

    public BigDecimal getLlevel() {
        return this.llevel;
    }

    public void setLlevel(BigDecimal llevel) {
        this.llevel = llevel;
    }

    public Fund getParentId() {
        return this.parentId;
    }

    public void setParentId(Fund parentId) {
        this.parentId = parentId;
    }

    public Boolean getIsnotleaf() {
        return this.isnotleaf;
    }

    public void setIsnotleaf(Boolean isnotleaf) {
        this.isnotleaf = isnotleaf;
    }

    public Boolean getIsactive() {
        return this.isactive;
    }

    public void setIsactive(Boolean isactive) {
        this.isactive = isactive;
    }

    public User getCreatedby() {
        return this.createdby;
    }

    public void setCreatedby(User createdby) {
        this.createdby = createdby;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public User getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(User lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }
}

