/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Min;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.CompositeUnique;
import org.egov.infra.persistence.validator.annotation.OptionalPattern;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.validation.exception.ValidationError;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="EGW_CONTRACTOR_GRADE")
@CompositeUnique(fields={"minAmount", "maxAmount"}, message="contractorgrade.amount.exist")
@Unique(fields={"grade"}, id="id", tableName="EGW_CONTRACTOR_GRADE", columnName={"GRADE"}, message="contractorGrade.grade.isunique")
@NamedQueries(value={@NamedQuery(name="getContractorGradeMaxAmountList", query=" select distinct(maxAmount) from ContractorGrade cg order by cg.maxAmount "), @NamedQuery(name="getContractorGradeMinAmountList", query=" select distinct(minAmount) from ContractorGrade cg order by cg.minAmount ")})
@SequenceGenerator(name="SEQ_EGW_CONTRACTOR_GRADE", sequenceName="SEQ_EGW_CONTRACTOR_GRADE", allocationSize=1)
public class ContractorGrade
extends AbstractAuditable {
    private static final long serialVersionUID = 4996716596644028190L;
    public static final String SEQ_EGW_CONTRACTOR_GRADE = "SEQ_EGW_CONTRACTOR_GRADE";
    public static final String GETCONTRACTORGRADEMAXAMOUNTLIST = "getContractorGradeMaxAmountList";
    public static final String GETCONTRACTORGRADEMINAMOUNTLIST = "getContractorGradeMinAmountList";
    @Id
    @GeneratedValue(generator="SEQ_EGW_CONTRACTOR_GRADE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Required(message="contractorGrade.grade.null")
    @Length(max=20, message="contractorGrade.grade.length")
    @OptionalPattern(regex="[0-9a-zA-Z-& :,/.()@]+", message="contractorGrade.grade.alphaNumeric")
    private String grade;
    @Required(message="contractorGrade.description.null")
    @Length(max=100, message="contractorGrade.description.length")
    private String description;
    @Column(name="MIN_AMOUNT")
    @Required(message="contractorGrade.minAmount.null")
    @Min(value=0L, message="contractorGrade.minAmount.valid")
    private BigDecimal minAmount;
    @Column(name="MAX_AMOUNT")
    @Required(message="contractorGrade.maxAmount.null")
    @Min(value=0L, message="contractorGrade.maxAmount.valid")
    private BigDecimal maxAmount;
    @Transient
    private String maxAmountString;
    @Transient
    private String minAmountString;

    public ContractorGrade() {
    }

    public ContractorGrade(String grade, String description, BigDecimal minAmount, BigDecimal maxAmount) {
        this.grade = grade;
        this.description = description;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getMinAmount() {
        return this.minAmount;
    }

    public void setMinAmount(BigDecimal minAmount) {
        this.minAmount = minAmount;
    }

    public BigDecimal getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(BigDecimal maxAmount) {
        this.maxAmount = maxAmount;
    }

    public String getMaxAmountString() {
        return this.maxAmountString;
    }

    public void setMaxAmountString(String maxAmountString) {
        this.maxAmountString = maxAmountString;
    }

    public String getMinAmountString() {
        return this.minAmountString;
    }

    public void setMinAmountString(String minAmountString) {
        this.minAmountString = minAmountString;
    }

    public List<ValidationError> validate() {
        List<ValidationError> errorList = null;
        if (this.minAmount != null && this.maxAmount != null && this.maxAmount.compareTo(this.minAmount) == -1) {
            return Arrays.asList(new ValidationError("maxAmount", "contractor.grade.maxamount.invalid"));
        }
        return errorList;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ContractorGrade [grade=").append(this.grade).append(", description=").append(this.description).append(", minAmount=").append(this.minAmount).append(", maxAmount=").append(this.maxAmount).append(", maxAmountString=").append(this.maxAmountString).append(", minAmountString=").append(this.minAmountString).append("]");
        return builder.toString();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

