/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.common.entity.Nationality;
import org.egov.commons.repository.NationalityRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class NationalityService {
    @Autowired
    private NationalityRepository nationalityRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public Nationality create(Nationality nationality) {
        return (Nationality)((Object)this.nationalityRepository.save((Object)nationality));
    }

    @Transactional
    public Nationality update(Nationality nationality) {
        return (Nationality)((Object)this.nationalityRepository.save((Object)nationality));
    }

    public List<Nationality> findAll() {
        return this.nationalityRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public Nationality findOne(Long id) {
        return (Nationality)((Object)this.nationalityRepository.findOne(id));
    }

    public List<Nationality> search(Nationality nationality) {
        Criteria criteria = this.getCurrentSession().createCriteria(Nationality.class);
        if (null != nationality.getName()) {
            criteria.add(Restrictions.ilike((String)"name", (String)nationality.getName(), (MatchMode)MatchMode.ANYWHERE));
        }
        return criteria.list();
    }
}

