/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.dao;

import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.EgPartytype;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;

@Repository
public class EgPartytypeHibernateDAO {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List findAllPartyTypeChild() {
        return this.getCurrentSession().createQuery("from EgPartytype pt where pt.egPartytype is not null order by upper(code)").list();
    }

    public List<EgPartytype> getPartyTypeDetailFilterBy(String code, String parentCode, String description) {
        StringBuffer qryStr = new StringBuffer();
        qryStr.append("select distinct ptype From EgPartytype ptype where ptype.createdby is not null ");
        Query qry = this.getCurrentSession().createQuery(qryStr.toString());
        if (code != null && !code.equals("")) {
            qryStr.append(" and (upper(ptype.code) like :code)");
            qry = this.getCurrentSession().createQuery(qryStr.toString());
        }
        if (parentCode != null && !parentCode.equals("")) {
            qryStr.append(" and (upper(ptype.egPartytype.code) like :parentCode)");
            qry = this.getCurrentSession().createQuery(qryStr.toString());
        }
        if (description != null && !description.equals("")) {
            qryStr.append(" and (upper(ptype.description) like :description)");
            qry = this.getCurrentSession().createQuery(qryStr.toString());
        }
        if (code != null && !code.equals("")) {
            qry.setString("code", "%" + code.toUpperCase().trim() + "%");
        }
        if (parentCode != null && !parentCode.equals("")) {
            qry.setString("parentCode", "%" + parentCode.toUpperCase().trim() + "%");
        }
        if (description != null && !description.equals("")) {
            qry.setString("description", "%" + description.toUpperCase().trim() + "%");
        }
        return qry.list();
    }

    public EgPartytype getPartytypeByCode(String code) {
        Query qry = this.getCurrentSession().createQuery("from EgPartytype pt where code=:code");
        qry.setString("code", code);
        return (EgPartytype)qry.uniqueResult();
    }

    public List<EgPartytype> getSubPartyTypesForCode(String code) {
        Query qry = this.getCurrentSession().createQuery("from EgPartytype pt where pt.egPartytype in (select pt1.id from EgPartytype pt1 where pt1.code=:code) and pt.egPartytype is not null");
        qry.setString("code", code);
        return qry.list();
    }

    public EgPartytype findById(Integer integer) {
        return (EgPartytype)this.getCurrentSession().get(EgPartytype.class, (Serializable)integer);
    }
}

