/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.egov.commons.Bankbranch;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="BANK")
@SequenceGenerator(name="SEQ_BANK", sequenceName="SEQ_BANK", allocationSize=1)
@Unique(fields={"code", "name"}, enableDfltMsg=true)
public class Bank
extends AbstractPersistable<Integer> {
    private static final long serialVersionUID = -2839424467289504649L;
    public static final String SEQ_BANK = "SEQ_BANK";
    @Id
    @GeneratedValue(generator="SEQ_BANK", strategy=GenerationType.SEQUENCE)
    @JsonIgnore
    private Integer id;
    @Required
    @Length(max=50)
    private String code;
    @Required
    @Length(max=100)
    private String name;
    @JsonIgnore
    @Length(max=250)
    private String narration;
    @JsonIgnore
    @Required
    private Boolean isactive;
    @JsonIgnore
    @Length(max=50)
    private String type;
    @JsonIgnore
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="bank", targetEntity=Bankbranch.class)
    private Set<Bankbranch> bankbranchs = new HashSet<Bankbranch>(0);
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="createdby")
    private User createdBy;
    @JsonIgnore
    private Date createdDate;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="lastModifiedBy")
    private User lastModifiedBy;
    @JsonIgnore
    private Date lastModifiedDate;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNarration() {
        return this.narration;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Set<Bankbranch> getBankbranchs() {
        return this.bankbranchs;
    }

    public void setBankbranchs(Set<Bankbranch> bankbranchs) {
        this.bankbranchs = bankbranchs;
    }

    public Boolean getIsactive() {
        return this.isactive;
    }

    public void setIsactive(Boolean isactive) {
        this.isactive = isactive;
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public User getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(User lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }
}

