/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infstr.models;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.utils.EntityType;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.models.ServiceAccountDetails;
import org.egov.infstr.services.PersistenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class ServiceSubledgerInfo {
    private Long id;
    private Accountdetailtype detailType;
    private Integer detailKeyId;
    private BigDecimal amount = BigDecimal.ZERO;
    private ServiceAccountDetails serviceAccountDetail;
    private EntityType entity;
    @Autowired
    private ApplicationContext context;

    public Accountdetailtype getDetailType() {
        return this.detailType;
    }

    public void setDetailType(Accountdetailtype detailType) {
        this.detailType = detailType;
    }

    public Integer getDetailKeyId() {
        return this.detailKeyId;
    }

    public void setDetailKeyId(Integer detailKeyId) {
        this.detailKeyId = detailKeyId;
    }

    public BigDecimal getAmount() {
        return null != this.amount ? this.amount.setScale(2, 6) : null;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public ServiceAccountDetails getServiceAccountDetail() {
        return this.serviceAccountDetail;
    }

    public void setServiceAccountDetail(ServiceAccountDetails serviceAccountDetail) {
        this.serviceAccountDetail = serviceAccountDetail;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDetailCode() {
        this.entity = this.getEntityInfo();
        return null != this.entity ? this.entity.getCode() : null;
    }

    public String getDetailKey() {
        return null != this.entity ? this.entity.getName() : null;
    }

    private EntityType getEntityInfo() throws ValidationException {
        EntityType entity = null;
        if (null == this.getDetailType() || null == this.detailType.getId() || this.detailType.getId().equals(0) || this.detailType.getId().equals(-1) || null == this.detailKeyId || this.detailKeyId.equals(0) || this.detailKeyId.equals(-1)) {
            return null;
        }
        try {
            Class<?> service = Class.forName(this.detailType.getFullQualifiedName());
            String detailTypeName = service.getSimpleName();
            String detailTypeService = detailTypeName.substring(0, 1).toLowerCase() + detailTypeName.substring(1) + "Service";
            PersistenceService entityPersistenceService = (PersistenceService)this.context.getBean(detailTypeService);
            String dataType = "";
            Method method = service.getMethod("getId", new Class[0]);
            dataType = method.getReturnType().getSimpleName();
            entity = dataType.equals("Long") ? (EntityType)entityPersistenceService.findById((Serializable)Long.valueOf(this.detailKeyId.toString()), false) : (EntityType)entityPersistenceService.findById((Serializable)this.detailKeyId, false);
        }
        catch (Exception e) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.add(new ValidationError("exp", e.getMessage()));
            throw new ValidationException(errors);
        }
        return entity;
    }
}

