/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.commons.Fund;
import org.egov.commons.repository.FundRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FundService {
    private final FundRepository fundRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public FundService(FundRepository fundRepository) {
        this.fundRepository = fundRepository;
    }

    @Transactional
    public Fund create(Fund fund) {
        if (fund.getParentId() != null && fund.getParentId().getId() == null) {
            fund.setParentId(null);
        }
        return (Fund)((Object)this.fundRepository.save((Object)fund));
    }

    @Transactional
    public Fund update(Fund fund) {
        return (Fund)((Object)this.fundRepository.save((Object)fund));
    }

    public List<Fund> findAll() {
        return this.fundRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public Fund findByName(String name) {
        return this.fundRepository.findByName(name);
    }

    public Fund findByCode(String code) {
        return this.fundRepository.findByCode(code);
    }

    public Fund findOne(Integer id) {
        return (Fund)((Object)this.fundRepository.findOne(id));
    }

    public List<Fund> search(Fund fund) {
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(Fund.class);
        Root funds = createQuery.from(Fund.class);
        createQuery.select((Selection)funds);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType Fund_ = m.entity(Fund.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (fund.getName() != null) {
            String name = "%" + fund.getName().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)funds.get("name")));
            predicates.add(cb.like(cb.lower((Expression)funds.get(Fund_.getDeclaredSingularAttribute("name", String.class))), name));
        }
        if (fund.getCode() != null) {
            String code = "%" + fund.getCode().toLowerCase() + "%";
            predicates.add(cb.isNotNull((Expression)funds.get("code")));
            predicates.add(cb.like(cb.lower((Expression)funds.get(Fund_.getDeclaredSingularAttribute("code", String.class))), code));
        }
        if (fund.getIsactive().booleanValue()) {
            predicates.add(cb.equal((Expression)funds.get("isactive"), (Object)true));
        }
        if (fund.getParentId() != null) {
            predicates.add(cb.equal((Expression)funds.get("parentId"), (Object)fund.getParentId()));
        }
        createQuery.where(predicates.toArray(new Predicate[0]));
        TypedQuery query = this.entityManager.createQuery(createQuery);
        List resultList = query.getResultList();
        return resultList;
    }

    public List<Fund> findByIsnotleaf() {
        return this.fundRepository.findByIsnotleaf(true);
    }
}

