/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFiscalPeriod;
import org.egov.commons.repository.CFinancialYearRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CFinancialYearService {
    private final CFinancialYearRepository cFinancialYearRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public CFinancialYearService(CFinancialYearRepository cFinancialYearRepository) {
        this.cFinancialYearRepository = cFinancialYearRepository;
    }

    @Transactional
    public CFinancialYear create(CFinancialYear cFinancialYear) {
        return (CFinancialYear)((Object)this.cFinancialYearRepository.save((Object)cFinancialYear));
    }

    @Transactional
    public CFinancialYear update(CFinancialYear cFinancialYear) {
        return (CFinancialYear)((Object)this.cFinancialYearRepository.save((Object)cFinancialYear));
    }

    public List<CFinancialYear> findAll() {
        return this.cFinancialYearRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"finYearRange"}));
    }

    public CFinancialYear findOne(Long id) {
        return (CFinancialYear)((Object)this.cFinancialYearRepository.findOne(id));
    }

    public List<CFinancialYear> search(CFinancialYear cFinancialYear) {
        if (cFinancialYear.getFinYearRange() != null) {
            return this.cFinancialYearRepository.findByFinancialYearRange(cFinancialYear.getFinYearRange());
        }
        return this.cFinancialYearRepository.findAll();
    }

    public Date getNextFinancialYearStartingDate() {
        List<CFinancialYear> cFinYear = this.cFinancialYearRepository.getFinYearLastDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(cFinYear.get(0).getEndingDate());
        cal.add(5, 1);
        return cal.getTime();
    }

    public CFiscalPeriod findByFiscalName(String name) {
        return this.cFinancialYearRepository.findByFiscalName(name);
    }
}

