/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.commons.Bank;
import org.egov.commons.EgwStatus;
import org.egov.commons.utils.EntityType;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="Supplier")
@SequenceGenerator(name="SEQ_SUPPLIER", sequenceName="SEQ_SUPPLIER", allocationSize=1)
@Unique(id="id", tableName="Supplier", fields={"code"}, columnName={"code"}, enableDfltMsg=true)
public class Relation
extends AbstractPersistable<Integer>
implements Serializable,
EntityType {
    private static final long serialVersionUID = -9041193691552971915L;
    public static final String SEQ = "SEQ_SUPPLIER";
    @Id
    @GeneratedValue(generator="SEQ_SUPPLIER", strategy=GenerationType.SEQUENCE)
    private Integer id;
    @Column(unique=true)
    @NotNull
    @Length(max=50)
    private String code;
    @NotNull
    @Length(max=50)
    private String name;
    @Length(max=300)
    private String address;
    @Length(max=10)
    private String mobile;
    @Length(max=25)
    private String email;
    @Length(max=250)
    private String narration;
    private Boolean isactive;
    @Length(max=10)
    private String panno;
    @Length(max=20)
    private String tinno;
    @Length(max=25)
    private String regno;
    @Length(max=25)
    private String bankaccount;
    @Length(max=12)
    private String ifsccode;
    @ManyToOne
    @JoinColumn(name="bank")
    private Bank bank;
    private Date lastmodifieddate;
    private Date createddate;
    private Long modifiedby;
    private Long createdby;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getNarration() {
        return this.narration;
    }

    public void setNarration(String narration) {
        this.narration = narration;
    }

    public Boolean getIsactive() {
        return this.isactive;
    }

    public void setIsactive(Boolean isactive) {
        this.isactive = isactive;
    }

    @Override
    public String getPanno() {
        return this.panno;
    }

    public void setPanno(String panno) {
        this.panno = panno;
    }

    @Override
    public String getTinno() {
        return this.tinno;
    }

    public void setTinno(String tinno) {
        this.tinno = tinno;
    }

    public String getRegno() {
        return this.regno;
    }

    public void setRegno(String regno) {
        this.regno = regno;
    }

    @Override
    public String getBankaccount() {
        return this.bankaccount;
    }

    public void setBankaccount(String bankaccount) {
        this.bankaccount = bankaccount;
    }

    @Override
    public String getIfsccode() {
        return this.ifsccode;
    }

    public void setIfsccode(String ifsccode) {
        this.ifsccode = ifsccode;
    }

    @Override
    public String getModeofpay() {
        return "";
    }

    @Override
    public Integer getEntityId() {
        return this.id;
    }

    @Override
    public String getEntityDescription() {
        return this.name;
    }

    @Override
    public EgwStatus getEgwStatus() {
        return null;
    }

    @Override
    public String getBankname() {
        if (this.bank != null) {
            return this.bank.getName();
        }
        return null;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Date getCreateddate() {
        return this.createddate;
    }

    public void setCreateddate(Date createddate) {
        this.createddate = createddate;
    }

    public Long getModifiedby() {
        return this.modifiedby;
    }

    public void setModifiedby(Long modifiedby) {
        this.modifiedby = modifiedby;
    }

    public Long getCreatedby() {
        return this.createdby;
    }

    public void setCreatedby(Long createdby) {
        this.createdby = createdby;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public Bank getBank() {
        return this.bank;
    }

    public Date getLastmodifieddate() {
        return this.lastmodifieddate;
    }

    public void setLastmodifieddate(Date lastmodifieddate) {
        this.lastmodifieddate = lastmodifieddate;
    }
}

