/*
 * Decompiled with CFR 0.152.
 */
package org.egov.commons.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.common.entity.UOM;
import org.egov.commons.repository.UOMRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class UOMService {
    private final UOMRepository uomRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public UOMService(UOMRepository uomRepository) {
        this.uomRepository = uomRepository;
    }

    @Transactional
    public UOM create(UOM uom) {
        return (UOM)((Object)this.uomRepository.save((Object)uom));
    }

    @Transactional
    public UOM update(UOM uom) {
        return (UOM)((Object)this.uomRepository.save((Object)uom));
    }

    public List<UOM> findAll() {
        return this.uomRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"uom"}));
    }

    public UOM findOne(Long id) {
        return (UOM)((Object)this.uomRepository.findOne(id));
    }

    public List<UOM> search(UOM uom) {
        if (uom.getUom() != null) {
            return this.uomRepository.findByUOM(uom.getUom());
        }
        return this.uomRepository.findAll();
    }

    public List<UOM> findAllOrderByCategory() {
        return this.uomRepository.findAllByOrderByUomCategoryIdAsc();
    }
}

